/**
 * @author 罗剑波
 * @email jumboluo@gmail.com
 * @description All rights reserved
 */

Ext.Loader.setConfig({enabled: true});

Ext.Loader.setPath('Ext.ux', 'extjs/ux');

Ext.require([
	'Ext.window.*',
	'Ext.tip.*',
	'Ext.tab.*',
	'Ext.form.*',
	'Ext.toolbar.*',
    'Ext.grid.*',
    'Ext.selection.*',
	'Ext.data.*',
	'Ext.container.*',
	'Ext.util.*',
	'Ext.LoadMask',
    'Ext.ux.CheckColumn',
    'Ext.ux.RowExpander',
    'Ext.ux.grid.plugin.RowEditing'
]);


var loadingMask = null;
var mainWin = null;
var realname = null;
var agentname = null;
var privileges = null;
var lastPassword = null;
var loginWin = null;
var thisrestaurant = {};

Ext.define('LoginForm', {
	extend : 'Ext.form.Panel',
	
	initComponent : function() {
		Ext.apply(this, {
			id : "login_form",
	        frame : false,
	        padding : 10,
	        buttonAlign : 'center', 
	        bodyStyle :'padding:10px',
	        fieldDefaults : {
	            msgTarget: 'under',
	            labelWidth: 60,
	            labelAlign: 'right'
	        },
	        defaultType : 'textfield',
	        defaults : {
	            anchor: '100%'
	        },
	
	        items : [{
				id : 'username',
				name : 'username',
				cls : 'user',
				fieldLabel : '用户名',
	//			minLength : 4,
	//			minLengthText : '用户名至少4个字符',
				enforceMaxLength : true,
				maxLength : 20,
				maxLengthText : '用户名不能超过20个字符',
	        	allowBlank : false,
				blankText : '用户名不能为空'
			}, {
				id : 'password',
				name : 'password',
				cls : 'key',
				fieldLabel : '密码',
	//			minLength: 4,
	//			minLengthText: '密码至少4个字符',
				enforceMaxLength : true,
				maxLength : 32,
				maxLengthText : '密码不能超过32个字符',
	        	allowBlank: false,
				blankText : '密码不能为空',
				inputType : 'password'
			}],
	        
	        buttons : [{
		        text: '重置',
		        handler: function() {
		            this.up('form').getForm().reset();
		        }
		    }, {
		        text: '登录',
		        formBind: true, //only enabled once the form is valid
		        disabled: true,
		        handler: this.login,
		        scope: this
		    }]
		});		
		this.callParent(arguments);
		
	},
	
	afterRender : function() {
		LoginForm.superclass.afterRender.apply(this, arguments);
		Ext.EventManager.addListener('login_form', 'keyup', function(e){if(e.keyCode==13) this.login();}, this);
	},
	
	loginSuccess : function(form, action) {
    	loginWin.close();
    	thisrestaurant = action.result.thisrestaurant;
    	isrestaurant = action.result.isrestaurant;
    	realname = action.result.realname;
    	displayname = action.result.displayname;
    	privileges = action.result.privileges;
    	loadingMask = new Ext.LoadMask(Ext.getBody(), {msg: "登陆成功，正在装载主界面..."});
    	loadingMask.show();
    	mainWin = new MainWin({isrestaurant: isrestaurant, realname: realname, displayname: displayname, privileges: privileges});
    	mainWin.show();
    	document.title = '后台管理系统';
    	loadingMask.hide();
	},
	
	loginFailed : function(form, action) {
		var pswField = form.findField('password');
		pswField.setValue(lastPassword);
		
		showFormFailureMsg( action, '登陆失败' );
	},
	
	login : function() {
		var form = this.getForm();
		if (form.isValid()) {
			var pswField = form.findField('password');
			lastPassword = pswField.getValue();
			var password = md5(lastPassword);
			pswField.setValue(password);
		    form.submit({
				url:'login.php',
				waitTitle : '请稍候',
				waitMsg : '正在登录...',
				method : 'POST',
		        success: this.loginSuccess,
		        failure: this.loginFailed,
		        scope: this
		    });
		}
	}
	
});

Ext.onReady(function(){	
	Ext.QuickTips.init();
		
	loginWin = Ext.create('Ext.window.Window', {
	    title: '后台登陆',
	    width: 300,
	    layout: 'fit',
		closable : false,
		resizable : false,
		border: false,
		modal: true,
		buttonlAlign : 'center',
		items: new LoginForm()
		
	});
	
//	loginWin.
//		
	Ext.get('loading-mask').fadeOut({remove:true});
	loginWin.show();
});
