if (!Ext.ModelManager.isRegistered('MyCustomReport')){
Ext.define('MyCustomReport', {
	extend : 'Ext.grid.Panel',
	alias  : 'widget.MyCustomReport',
	
	initComponent : function() {
		this.store = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'Commission',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'commissions.php',
				extraParams: {
					close : true
				},
				timeout : 30*60*1000,
				reader: {
					type: 'json',
					root: 'commissions',
					totalProperty: 'total',
					id: 'id'
				}
			},
			listeners: {
				load: function(store, records, successful, operation, opts) {
					store.getProxy().extraParams.close = false;
				}
			},
			autoLoad: true
		});
		
		
		Ext.apply(this, {
			id : 'widget.MyCustomReport',
			title : '财务管理-自定义查询',
			closable : true,
			autoScroll : true,
	        columns: [
	        	{
	        		xtype	 : 'rownumberer',
	                width    : 40
	        	},
	        	{
	                text     : '代理名称',
	                width    : 180,
	                sortable : true,
	                dataIndex: 'Agent',
	                hidden	 : true
	            },
	            {
	                text     : '餐馆名称',
	                width    : 180,
	                sortable : true,
	                dataIndex: 'Restaurant',
	                hidden	 : true
	            },
	            {
	                text     : '年份',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'Year'
	            },
	            {
	                text     : '月份',
	                width    : 40,
	                sortable : true,
	                dataIndex: 'Month'
	            },
	            {
	                text     : '时间',
	                width    : 150,
	                sortable : true,
	                dataIndex: 'Days'
	            },
	            {
	                text     : '销售额（元）',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Sale',
	                align : 'right'
	            },
	            {
	                text     : '佣金比率（%）',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Rate',
	                align : 'right'
	            },
	            {
	                text     : '佣金费（元）',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'Commission',
	                align : 'right'
	            },
	            {
	                text     : '状态',
	                minWidth : 200,
	                sortable : true,
	                dataIndex: 'Status',
	                align	 : 'center'
	            }
	        ],
	        dockedItems: [{
				xtype: 'pagingtoolbar',
				store: this.store,   // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true
			},{
				xtype: 'toolbar',
				items: ['搜索　',{
					xtype: 'numberfield',
					width: 60,
					name: 'searchYear',
//					value: new Date().getFullYear(),
					hideLabel: true,
					minValue: 2012,
					maxValue: 2030,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchYear = newValue;
						}
					}
				},'年　',{
					xtype: 'numberfield',
					width: 40,
					name: 'searchMonth',
					hideLabel: true,
//					value: (new Date().getMonth()+1),
					minValue: 1,
					maxValue: 12,
					allowDecimals: false,
	                listeners: {
						scope: this,
						'change' : function(field, newValue, oldValue){
							this.searchMonth = newValue;
						}
					}
				},'月','　状态',{
					xtype: 'combo',
					width: 80,
					name: 'searchStatus',
					hideLabel: true,
					store: [
	                    ['','全部'],
	                    ['已结算','已结算'],
						['未结算','未结算']
	                ],
	                lazyRender: true,
	                listClass: 'x-combo-list-small',
	                listeners: {
						scope: this,
						'select' : function(combobox, value){
							this.searchStatus = value[0].data.field1;
						}
					}
				},' ',{
					text:'开始搜索',
					tooltip:'开始搜索',
					iconCls:'search',
					scope: this,
					handler: this.startSearch
				}]
			}]
		});
		this.callParent(arguments);
	},
	
	startSearch : function() {
		var store = this.store;
		var proxy = store.getProxy();
		proxy.extraParams.searchText = this.searchText;
		proxy.extraParams.searchYear = this.searchYear;
		proxy.extraParams.searchMonth = this.searchMonth;
		proxy.extraParams.searchStatus = this.searchStatus;
		store.loadPage(1);
	}
});
}