Ext.define('OrderDetailWindow', {
	extend: 'Ext.window.Window',
	resizable : false,
	layout : 'fit',
	y: 100,
	width: 500,
	maxHeight: 700,
	title: '订单详情',
	bodyPadding: '10px',
	initComponent : function() {
		var tpl  = new Ext.Template(
			'<!--startprint-->',
			'<table class="order_detail_table">',
				'<tr>',
					'<td class="label">餐馆：</td>',
					'<td>{Restaurant}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">代理：</td>',
					'<td>{Agent}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">客户：</td>',
					'<td>{CustomName}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">类型：</td>',
					'<td>{Takeout}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">客户手机：</td>',
					'<td>{Mobile}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">客户地址：</td>',
					'<td>{Address}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">就餐时间：</td>',
					'<td>{TimeNote}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">验证码：</td>',
					'<td>{VeriCode}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">要求：</td>',
					'<td>{Notes}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">餐品信息：</td>',
					'<td id="dishsInfo"></td>',
				'</tr>',
				'<tr>',
					'<td class="label">合计：</td>',
					'<td>{Total}元</td>',
				'</tr>',
				'<tr>',
					'<td class="label">折扣：</td>',
					'<td>{Discount}折</td>',
				'</tr>',
				'<tr>',
					'<td class="label">应收：</td>',
					'<td>{DiscountTotal}元</td>',
				'</tr>',
				'<tr>',
					'<td class="label">创建时间：</td>',
					'<td>{CreateTime}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">开始送餐时间：</td>',
					'<td>{CTime}</td>',
				'</tr>',
				'<tr>',
					'<td class="label">结束时间：</td>',
					'<td>{EndTime}</td>',
				'</tr>',
				'<!--endprint-->',
				'<tr>',
					'<td class="label" id="phide1">已发短信给餐馆：</td>',
					'<td><input type="checkbox" {SmsSent}/></td>',
				'</tr>',
				'<tr>',
					'<td class="label" id="phide2">催餐：</td>',
					'<td><input type="checkbox" {Urged}/></td>',
				'</tr>',
				'<tr>',
					'<td class="label"><input  type="button" value="打印" onclick="printOrder()" /></td>',
				'</tr>',
				
			'</div>',
			{compiled: true}
			
		);
		
		
		
		
		var itemstore = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'OrderItem',
			proxy: {
				type: 'ajax',
				url: 'orderitems.php',
				extraParams : {orderid : this.order.id},
				reader: {
					type: 'json',
					root: 'orderitems',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true,
			listeners:{
				scope:this,
				load:function(_this, records,successful,operation,eOpts){
					var str="";
					var count=_this.getCount();
					for(var i=0;i<count;i++){
						var item=_this.getAt(i).data;
						
//						console.log(item.data);
						str+=item.Name+"&nbsp;&nbsp;&nbsp;"+item.Count+"X"+item.Price+"元<br/>";
					}
					document.getElementById('dishsInfo').innerHTML=str;
				}
			}
		});
		
		var processstore = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'OrderProcess',
			proxy: {
				type: 'ajax',
				url: 'orderprocess.php',
				extraParams : {orderid : this.order.id},
				reader: {
					type: 'json',
					root: 'orderprocess',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true
		});
		
		
		Ext.apply(this, {
			items: [{
            	title: '订单信息',
            	html : tpl.applyTemplate({
            		Restaurant : this.order.Restaurant,
            		Agent: this.order.Agent,
            		CustomName: this.order.CustomName,
            		Mobile : this.order.Mobile,
            		Address : this.order.Address,
            		Notes : this.order.Notes,
            		Total : this.order.Total,
            		CreateTime : this.order.CreateTime,
            		CTime : this.order.CTime,
            		EndTime : this.order.EndTime,
            		Takeout : this.order.Takeout,
            		TimeNote : this.order.TimeNote,
            		Discount : this.order.Discount,
            		DiscountTotal : this.order.DiscountTotal,
            		VeriCode : this.order.VeriCode,
            		SmsSent : this.order.SmsSent ? 'checked="checked"' : '',
            		Urged : this.order.Urged ? 'checked="checked"' : ''
            	})
			},{
				xtype: 'grid',
				title: '餐饮列表',
				autoScroll : true,
				viewConfig: {
	            	stripeRows: true
				},
				columns: [{
	                text     : '餐品名称',
	                flex	 : 1,
	                sortable : true,
	                dataIndex: 'Name'
	            },
	            {
	                text     : '价格',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'Price'
	            },
	            {
	                text     : '数量',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'Count'
	            }],
				store : itemstore
			},
			{
				xtype: 'grid',
				title: '订单活动历史',
				autoScroll : true,
				viewConfig: {
	            	stripeRows: true
				},
				columns: [{
	                text     : '时间',
	                width    : 140,
	                sortable : true,
	                dataIndex: 'Time'
	            },
	            {
	                text     : '活动',
	                flex	 : 1,
	                sortable : true,
	                dataIndex: 'Activity'
	            }],
				store : processstore
			}]
		});
		
		
		
		this.callParent(arguments);
		
		
	}


});

function printOrder()
{
	bdhtml=window.document.body.innerHTML;    
    sprnstr="<!--startprint-->";    
    eprnstr="<!--endprint-->";    
    prnhtml=bdhtml.substr(bdhtml.indexOf(sprnstr)+17);    
    prnhtml=prnhtml.substring(0,prnhtml.indexOf(eprnstr));    
    window.document.body.innerHTML=prnhtml;
    location.reload();
    window.print();
    
}

