if (!Ext.ModelManager.isRegistered('RestaurantList')){
Ext.define('RestaurantList', {
	extend : 'Ext.grid.Panel',
	alias  : 'widget.RestaurantList',
	
	initComponent : function() {
		this.store = Ext.create('Ext.data.Store',{
			storeId: 'restaurantsListRestaurantsStore',
			autoDestroy: true,
			model: 'Restaurant',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'restaurants.php',
				reader: {
					type: 'json',
					root: 'restaurants',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true
		});
		
		this.cityStore = Ext.create('Ext.data.Store',{
			autoDestroy: true,
			model: 'City',
			pageSize: 20,
			proxy: {
				type: 'ajax',
				url: 'cities.php',
				reader: {
					type: 'json',
					root: 'cities',
					totalProperty: 'total',
					id: 'id'
				}
			},
			autoLoad: true,
			listeners: {
				'load': function(store, records,successful,op){
					var r = Ext.create('City', {
						id: '0',
						name: '全部'
					});
					store.insert(0, r);
				}
			}
		});
		
		Ext.apply(this, {
			id : 'widget.RestaurantList',
			title : '餐馆列表',
			closable : true,
			autoScroll : true,
	        viewConfig: {
	            stripeRows: true
	        },
	        selModel: Ext.create('Ext.selection.CheckboxModel', {mode: 'SINGLE', allowDeselect: true}),
	        columns: [
//				{xtype: 'rownumberer'},
//	            {
//	                text     : 'ID',
//	                width    : 50,
//	                sortable : true,
//	                dataIndex: 'id'
//	            },
	            {
	                text     : '餐馆名称',
	                width    : 180,
	                sortable : true,
	                dataIndex: 'name'
	            },
	            {
	                text     : '所属城市',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'city'
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '城市默认',
	                width    : 60,
	                editable : false, //由我扩展，哈哈。
	                sortable : true,
	                dataIndex: 'citydefault'
	            },
	            {
	                text     : '所属代理',
	                width    : 120,
	                sortable : true,
	                dataIndex: 'agent'
	            },
	            {
	                text     : '电话',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'telephone'
	            },
	            {
	                text     : '外卖时间',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'businesshour'
	            },
	            {
	                text     : '外卖说明',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'businessmemo'
	            },
	            {
					xtype: 'numbercolumn',
	                text     : '送餐费用',
	                width    : 60,
					format   : '￥0.00',
	                sortable : true,
	                dataIndex: 'fee'
	            },
	            {
					xtype: 'numbercolumn',
	                text     : '起送金额',
	                width    : 60,
					format   : '￥0.00',
	                sortable : true,
	                dataIndex: 'minmoney'
	            },
	            {
	                text     : '送餐范围',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'scope'
	            },
	            {
	                text     : '送餐折扣',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'discount'
	            },
	            {
					xtype: 'checkcolumn',
	                text     : '送餐？',
	                width    : 40,
	                sortable : true,
	                dataIndex: 'takeout'
	            },
	            {
	                text     : '到店折扣',
	                width    : 60,
	                sortable : true,
	                dataIndex: 'discountin'
	            },
	            {
	                text     : '优惠信息',
	                width    : 150,
	                sortable : true,
	                dataIndex: 'salead'
	            },
	            {
	                text     : '主食类',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'staple',
	                hidden	 : true
	            },
	            {
	                text     : '打印机启用',
	                width    : 150,
	                sortable : true,
	                dataIndex: 'isprint'
	            },
	            {
	            	text     : '商户编码',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'membercode',
	                hidden	 : true
	            },
	            {
	            	text     : 'API密匙',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'feyinkey',
	                hidden	 : true
	            }
	            ,
	            {
	            	text     : '设备编码',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'deviceno',
	                hidden	 : true
	            }
	            ,
	            {
	                text     : '坐标纬度',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'latitude',
	                hidden	 : true
	            },
	            {
	                text     : '坐标经度',
	                width    : 100,
	                sortable : true,
	                dataIndex: 'longitude',
	                hidden	 : true
	            },
	            {
	                xtype: 'actioncolumn',
	                flex: 1,
	                items: [{
	                    icon   : 'images/delete.png',
	                    altText: '删除餐馆',
	                    tooltip: '删除餐馆',
	                    handler: this.deleteRestaurant,
	                    scope: this
	                }, {
	                    icon   : 'images/edit.png',
	                    altText: '修改餐馆信息',
	                    tooltip: '修改餐馆信息',
	                    handler: this.editRestaurant,
	                    scope: this
	                }]
	            }
	        ],
	        dockedItems: [{
				xtype: 'pagingtoolbar',
				store: this.store,   // same store GridPanel is using
				dock: 'bottom',
				displayInfo: true
			},{
				xtype: 'toolbar',
				items: [{
					text: '添加餐馆',
					tooltip: '添加一个餐馆',
					iconCls: 'add',
					scope: this,
					handler: this.addRestaurant
				}, '-', {
					text:'修改餐馆信息',
					tooltip:'修改所选的餐馆的信息',
					iconCls:'edit',
					scope: this,
					handler: this.editSelectedRestaurants
				},'-',{
					text:'删除餐馆',
					tooltip:'批量删除所选的餐馆',
					iconCls:'delete',
					scope: this,
					handler: this.deleteSelectedRestaurants
				},'-','搜索',{
					xtype: 'textfield',
					name: 'searchText',
					tooltip:{text:'可以在此输入餐馆名称、所属代理名称、地址、电话、联系人等进行模糊查询。',title:'搜索提示'},
					hideLabel: true,
					width: 200,
					listeners: {
						 change: {
						 	fn: this.onTextFieldChange,
						 	scope: this,
							buffer: 100
						 },
						 afterrender: {
						 	fn: function(field) {
							 		if(field.tooltip.text){   
					                    new Ext.ToolTip({
					                        target:field.id,
					                        trackMouse:false,
					                        draggable:true,
					                        maxWidth:300,
					                        minWidth:100,
					                        title:"<span style='color:green'>" + field.tooltip.title + "</span>",
					                        html:"<span style='color:green'>" + field.tooltip.text + "</span>"
					                    }); 
					                }  
							 	}
						 }
					}
				},'所属城市',{
					xtype: 'combo',
					width: 80,
					name: 'searchCity',
					hideLabel: true,
					store: this.cityStore, //TODO
					queryMode: 'local',
					displayField: 'name',
					valueField: 'id',
					listeners: {
						scope: this,
						'select' : function(combobox, value){
							this.searchCityId = value[0].data.id;
							this.searchCityName = value[0].data.name;
						}
					}
				},{
					text:'开始搜索',
					tooltip:'开始搜索',
					iconCls:'search',
					scope: this,
					handler: this.startSearch
				}]
			}]
		});
		this.callParent(arguments);
	},
	
	startSearch : function() {
		var store = this.store;
		var proxy = store.getProxy();
		proxy.extraParams.searchText = this.searchText;
		proxy.extraParams.searchCityId = this.searchCityId;
		store.loadPage(1);
	},
	
	onTextFieldChange : function(field, newValue, oldValue) {
		this.searchText = newValue;
	},
	
	addRestaurant : function () {
		var widget = "widget.AddRestaurant"
		var main = Ext.getCmp("content-panel");
		var tab = main.getComponent(widget);
		if(tab) {
			main.setActiveTab(tab);
		}
		else {
			var newTab = main.add(Ext.create(widget));
			main.setActiveTab(newTab)
		}
	},
	
	editSelectedRestaurants : function () {
		for(var i=0; i<this.selModel.selected.items.length; i++) {
			var restaurant = this.selModel.selected.items[i].data;
			this.openEditRestaurantWidget(restaurant);
		}
	},
	
	openEditRestaurantWidget : function ( restaurant ) {
		var widget = "widget.EditRestaurant"
		var main = Ext.getCmp("content-panel");
		var tab = main.getComponent(widget+"_"+restaurant.id);
		if(tab) {
			main.setActiveTab(tab);
		}
		else {
			var newTab = main.add(Ext.create(widget,{
				restaurant : restaurant
			}));
			main.setActiveTab(newTab)
		}
	},
	
	deleteSelectedRestaurants : function () {
		var items = this.selModel.selected.items;
		if( items.length>0 ){
			var ids = "";
			var namesHtml = "";
			var names = "";
			for(var i=0; i<items.length; i++){
				ids += (i==0 ? "" : ",") + items[i].data.id;
				namesHtml += "<b>"+items[i].data.name+"</b><br>";
				names += (i==0 ? "" : ",") + items[i].data.name;
			}
			Ext.MessageBox.confirm("删除确认",
				"确认要删除以下餐馆吗？<br>"+namesHtml,
				function ( btn ) {
					if ( btn == 'yes' ) {
			    		Ext.Ajax.request({
			    			url: 'delete_restaurants.php',
			    			params: {ids: ids, names: names},
			    			method: 'POST',
			    			success: this.deleteRestaurantSuccess,
			    			failure: this.deleteRestaurantFailure,
			    			scope: this
			    		});
					}
				},
				this
			);
			
		}
	},
	
	editRestaurant : function(grid, rowIndex, colIndex) {
		var restaurant = grid.store.data.items[rowIndex].data;
		alert(restaurant);
		this.openEditRestaurantWidget(restaurant);
    },
	
	deleteRestaurant : function(grid, rowIndex, colIndex) {
		if(grid.store.data.items[rowIndex].data.id && grid.store.data.items[rowIndex].data.name){
			var id = grid.store.data.items[rowIndex].data.id;
			var name = grid.store.data.items[rowIndex].data.name;
			Ext.MessageBox.confirm("删除确认",
				"确认要删除以下餐馆吗？<br><b>"+name+"</b>",
				function ( btn ){
					if( btn == 'yes' ){
			    		Ext.Ajax.request({
			    			url: 'delete_restaurant.php',
			    			params: {id: id, name: name},
			    			method: 'POST',
			    			success: this.deleteRestaurantSuccess,
			    			failure: this.deleteRestaurantFailure,
			    			scope: this
			    		});
					}
				},
				this
			);
		}
    },
    
    deleteRestaurantSuccess : function(response, opts) {
    	this.store.load();
    	showAjaxResponseMsg( response, "删除餐馆");
    },
    
    deleteRestaurantFailure : function(response, opts) {
    	this.store.load();
    	showAjaxResponseMsg( response, "删除餐馆");
    }
});
}