if (!Ext.ModelManager.isRegistered('ScoreSetWidget')){
Ext.define('ScoreSetWidget', {
	extend : 'Ext.form.Panel',
	alias  : 'widget.ScoreSetWidget',
	
	initComponent : function() {
		var settings = Ext.create('Ext.data.Store', {
			model: 'scoreReg',
			proxy: {
				type: 'ajax',
				url: 'scoreReg.php',
				reader: {
					type: 'json',
					root: 'scoreReg'
				}
			},
			listeners: {
				'load': function(store, records, options) {
					if(records && records.length>0){
						this.getForm().loadRecord(records[0]);
					}
				},
				scope: this
			}
		});
		settings.load();
		Ext.apply(this, {
			id : 'widget.ScoreSet',
			title : '积分兑换规则',
			closable : true,
			autoScroll : true,
    		bodyPadding: 10,
	        fieldDefaults : {
	            msgTarget: 'side',
	            labelWidth: 100,
	            labelAlign: 'right'
	        },
    		defaultType: 'numberic',
    		items: [{
            	xtype: 'fieldset',
            	title: '积分规则设置',
    			defaultType: 'numberfield',	
    			padding: 10,
            	items: [{
	    			fieldLabel: '订餐积分',
	    			width: 200,
					name: 'dingcanscore',
					allowBlank: false,
					blankText : '订餐积分规则不能为空',
						maxValue: 100,
		    	        minValue: 0
            	},{
            		xtype: 'label',
            		text: '这里请设置餐品的百分比,例如设置50，那么就按照消费的50%来确定所获的积分',
            		cls: 'form_tips'
            	}
            	/*,{
	    			fieldLabel: '留言积分',
	    			width: 300,
					name: 'pinglunscore',
	    	        minValue: 0,
					//regex: /^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,4}$/,
				//	regexText : '这是在发送验证电子邮件的时候显示的发件人邮箱地址，请填写有效的EMAIL地址',
					allowBlank: false,
					blankText : '留言积分规则不能为空'
            	},{
            		xtype: 'label',
            		text: '这里的设置时根据每次用户发表品论，所获得的积分，例如3，那么客户评论后将或的3个积分',
            		cls: 'form_tips'
            	}  */
            	]
    		},
    		/*
    		{
            	xtype: 'fieldset',
            	title: '积分温馨提示',
    			defaultType: 'textareafield',	
    			padding: 10,
            	items: [{
	    			fieldLabel: '温馨提示1',
	    			width: 400,
					name: 'tip1',
					allowBlank: false,
					blankText : '请设置温馨提示1的内容'
            	},{
            		xtype: 'label',
            		text: '这里设置礼品中心中的温馨提示1的内容',
            		cls: 'form_tips'
            	},{
	    			fieldLabel: '温馨提示2',
	    			width: 400,
					name: 'tip2',
					allowBlank: false,
					blankText : '请设置温馨提示1的内容'
            	},{
            		xtype: 'label',
            		text: '这里设置礼品中心中的温馨提示2的内容',
            		cls: 'form_tips'
            	}]
    		},    */
    		{
    			xtype: 'panel',
    			border: false,
    			frame: false,
	    		buttonAlign: 'left',
				buttons: [{
		            text: '保存',
		            handler: this.submitForm,
		            scope: this
		        },{
		            text: '重置',
		            handler: function() {this.getForm().reset();},
		            scope: this
		        }]
    		}]
		});
		this.callParent(arguments);
	},
	
	submitForm : function() {
		var form = this.getForm();
		if (form.isValid()) {
			this.submit({
				//url:'settings_save.php',
				url:'scorereg_save.php',
				waitTitle : '请稍候',
				waitMsg : '正在保存积分规则...',
				method : 'POST',
		        success: this.saveSettingsSuccess,
		        failure: this.saveSettingsFailure,
		        scope: this
		    });
		}
		else {
			showErrorMsg('某些输入项不符合规定，请检查各字段的输入。','输入有误。');
		}
	},
	
	saveSettingsSuccess : function (form, action) {
		showSuccessMsg('积分规则配置成功。');
	},
	
	saveSettingsFailure : function (form, action) {
		showFormFailureMsg( action, '保存规则失败');
	}
	
});
}