Ext.define('Agent', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'},
		{name: 'level', type: 'int'},
		{name: 'headid', type: 'int'},
		{name: 'head', type: 'string'},
		{name: 'ancestors', type: 'string'},
		{name: 'cityid', type: 'int'},
		{name: 'city', type: 'string'},
		{name: 'username', type: 'string'},
		{name: 'privileges', type: 'string'},
		{name: 'realname', type: 'string'},
		{name: 'telephone', type: 'string'},
		{name: 'mobile', type: 'string'},
		{name: 'memo', type: 'string'},
		{name: 'adddate', type: 'string'},
		{name: 'rate', type: 'float'}
	]
});

Ext.define('City', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'},
		{name: 'latitude', type: 'float'},
		{name: 'longitude', type: 'float'},
		{name: 'zoomlevel', type: 'int'},
		{name: 'sequence', type: 'int'},
		{name: 'img1', type: 'string'},
		{name: 'img2', type: 'string'},
		{name: 'img3', type: 'string'},
		{name: 'img4', type: 'string'},
		{name: 'img5', type: 'string'},
		{name: 'imgurl1', type: 'string'},
		{name: 'imgurl2', type: 'string'},
		{name: 'imgurl3', type: 'string'},
		{name: 'imgurl4', type: 'string'},
		{name: 'imgurl5', type: 'string'},
		{name: 'status', type: 'string'}
	]
});
Ext.define('street', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'},
		{name: 'cityId', type: 'int'},
		{name: 'cityName', type: 'string'},
		{name: 'regionId', type: 'int'},
		{name: 'regionName', type: 'string'},
		{name: 'zoomlevel', type: 'int'},
		{name: 'hide', type: 'int'},
		{name: 'sequence', type: 'string'},
		{name: 'lat', type: 'string'},
		{name: 'lng', type: 'string'}
	]
});
Ext.define('City_cb', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'}
//		{name: 'latitude', type: 'float'},
//		{name: 'longitude', type: 'float'},
//		{name: 'zoomlevel', type: 'int'},
//		{name: 'sequence', type: 'int'}
	]
});

Ext.define('Region', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'},
		{name: 'cityid', type: 'int'},
		{name: 'city', type: 'string'},
		{name: 'latitude', type: 'float'},
		{name: 'longitude', type: 'float'},
		{name: 'zoomlevel', type: 'int'},
		{name: 'sequence', type: 'int'}
	]
});

Ext.define('Restaurant', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'},
		{name: 'telephone', type: 'string'},
		{name: 'cityid', type: 'int'},
		{name: 'city', type: 'string'},
		{name: 'regionid', type: 'int'},
		{name: 'region', type: 'string'},
		{name: 'citydefault', type: 'boolean'},
		{name: 'latitude', type: 'float'},
		{name: 'longitude', type: 'float'},
		{name: 'agentid', type: 'int'},
		{name: 'agent', type: 'string'},
		{name: 'rating', type: 'int'},
		{name: 'mobile', type: 'string'},
		{name: 'businesshour', type: 'string'},
		{name: 'businessmemo', type: 'string'},
		{name: 'fee', type: 'float'},
		{name: 'minmoney', type: 'float'},
		{name: 'scope', type: 'int'},
		{name: 'discount', type: 'string'},
		{name: 'notice', type: 'string'},
		{name: 'takeout', type: 'boolean'},
		{name: 'address', type: 'string'},
		{name: 'linkman', type: 'string'},
		{name: 'linkphone', type: 'string'},
		{name: 'keyword', type: 'string'},
		{name: 'memo', type: 'string'},
		{name: 'commission', type: 'int'},
		{name: 'username', type: 'string'},
		{name: 'addtime', type: 'string'},
		{name: 'membercode', type: 'string'},
		{name: 'feyinkey', type: 'string'},
		{name: 'deviceno', type: 'string'},
		{name: 'discountin', type: 'string'},
		{name: 'salead', type: 'string'},
		{name: 'staple', type: 'string'},
		{name: 'isprint', type: 'boolean'},
		{name: 'membercode', type: 'string'},
		{name: 'feyinkey', type: 'string'},
		{name: 'deviceno', type: 'string'},
		{name: 'restaurantImage', type: 'string'}
	]
});

Ext.define('Section', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'},
		{name: 'restaurantid', type: 'int'},
		{name: 'restaurant', type: 'string'},
		{name: 'denyorder', type: 'boolean'},
		{name: 'lastupdate', type: 'string'},
		{name: 'sequence', type: 'int'}
	]
});
//餐品的Model
Ext.define('Dish', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'name', type: 'string'},
		{name: 'sectionid', type: 'int'},
		{name: 'section', type: 'string'},
		{name: 'restaurantid', type: 'int'},
		{name: 'restaurant', type: 'string'},
		{name: 'annotation', type: 'string'},
		{name: 'price', type: 'float'},
		{name: 'discountprice', type: 'float'},
		{name: 'denyorder', type: 'boolean'},
		{name: 'lastupdate', type: 'string'},
		{name: 'sequence', type: 'int'},
		{name: 'imagePath', type: 'string'}
	]
});

Ext.define('Custom', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'Email', type: 'string'},
		{name: 'Mobile', type: 'string'},
		{name: 'Username', type: 'string'},
		{name: 'CityHint', type: 'boolean'},
		{name: 'WelcomeHint', type: 'boolean'},
		{name: 'MapHint', type: 'boolean'},
		{name: 'RegTime', type: 'string'},
		{name: 'RegType', type: 'string'},
		{name: 'LastClient', type: 'string'},
		{name: 'LastCityID', type: 'int'},
		{name: 'LastCity', type: 'string'},
		{name: 'LastIp', type: 'string'},
		{name: 'LastTime', type: 'string'},
		{name: 'Corporation', type: 'string'},
		{name: 'EmailVerified', type: 'boolean'},
		{name: 'MobileVerified', type: 'boolean'},
		{name: 'MobileVerifying', type: 'boolean'},
		{name: 'customScore', type: 'int'}
	]
});


Ext.define('CustomLog', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'CustomID', type: 'int'},
		{name: 'Username', type: 'string'},
		{name: 'Email', type: 'string'},
		{name: 'Mobile', type: 'string'},
		{name: 'OpTime', type: 'string'},
		{name: 'IP', type: 'string'},
		{name: 'Operation', type: 'string'},
		{name: 'Data', type: 'string'}
	]
});

Ext.define('AgentLog', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'AgentID', type: 'int'},
		{name: 'Name', type: 'string'},
		{name: 'CityID', type: 'int'},
		{name: 'City', type: 'string'},
		{name: 'Realname', type: 'string'},
		{name: 'Username', type: 'string'},
		{name: 'OpTime', type: 'string'},
		{name: 'IP', type: 'string'},
		{name: 'Operation', type: 'string'},
		{name: 'Data', type: 'string'}
	]
});

Ext.define('QA', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'CustomID', type: 'int'},
		{name: 'Email', type: 'string'},
		{name: 'Name', type: 'string'},
		{name: 'IP', type: 'string'},
		{name: 'Question', type: 'string'},
		{name: 'QTime', type: 'string'},
		{name: 'Answer', type: 'string'},
		{name: 'ATime', type: 'string'},
		{name: 'Show', type: 'boolean'}
	]
});

Ext.define('Sms', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'Receiver', type: 'string'},
		{name: 'Content', type: 'string'},
		{name: 'SentTime', type: 'string'},
		{name: 'RecvTime', type: 'string'},
		{name: 'Success', type: 'boolean'},
		{name: 'ReturnStatus', type: 'string'},
		{name: 'Result', type: 'string'},
		{name: 'ReferenceID', type: 'string'},
		{name: 'Status', type: 'string'},
		{name: 'Remain', type: 'string'},
		{name: 'CustomID', type: 'int'}
	]
});

Ext.define('SmsQueue', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'Receiver', type: 'string'},
		{name: 'Content', type: 'string'},
		{name: 'isCustom', type: 'boolean'},
		{name: 'CustomID', type: 'int'},
		{name: 'Username', type: 'string'}
	]
});

Ext.define('Order', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'CustomID', type: 'int'},
		{name: 'CustomName', type: 'string'},
		{name: 'RestaurantID', type: 'int'},
		{name: 'Restaurant', type: 'string'},
		{name: 'Agent', type: 'string'},
		{name: 'Mobile', type: 'string'},
		{name: 'Address', type: 'string'},
		{name: 'Notes', type: 'string'},
		{name: 'Total', type: 'string'},
		{name: 'CreateTime', type: 'string'},
		{name: 'Status', type: 'string'},
		{name: 'CTime', type: 'string'},
		{name: 'Urged', type: 'boolean'},
		{name: 'SmsSent', type: 'boolean'},
		{name: 'EndTime', type: 'string'},
		{name: 'Takeout', type: 'string'},
		{name: 'TimeNote', type: 'string'},
		{name: 'Discount', type: 'string'},
		{name: 'DiscountTotal', type: 'string'},
		{name: 'VeriCode', type: 'string'}
	]
});

Ext.define('OrderItem', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'OrderID', type: 'int'},
		{name: 'DishID', type: 'int'},
		{name: 'Name', type: 'string'},
		{name: 'section', type: 'string'},
		{name: 'annotation', type: 'string'},
		{name: 'Price', type: 'float'},
		{name: 'Count', type: 'int'},
		{name: 'RestaurantID', type: 'int'},
		{name: 'Restaurant', type: 'string'}
	]
});

Ext.define('OrderProcess', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'OrderID', type: 'int'},
		{name: 'Type', type: 'int'},
		{name: 'Time', type: 'string'},
		{name: 'Activity', type: 'string'}
	]
});


Ext.define('CustomAddress', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'CustomID', type: 'int'},
		{name: 'Address', type: 'string'}
	]
});


Ext.define('Commission', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'RestaurantID', type: 'int'},
		{name: 'Restaurant', type: 'string'},
		{name: 'AgentID', type: 'int'},
		{name: 'Agent', type: 'string'},
		{name: 'Year', type: 'int'},
		{name: 'Month', type: 'int'},
		{name: 'Day', type: 'string'},
		{name: 'Days', type: 'string'},
		{name: 'Sale', type: 'string'},
		{name: 'Rate', type: 'string'},
		{name: 'Commission', type: 'string'},
		{name: 'Status', type: 'string'},
		{name: 'CloseTime', type: 'string'}
	]
});


Ext.define('CommissionTreeNode', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'CmsID', type: 'int'},
		{name: 'text', type: 'string'},
		{name: 'leaf', type: 'boolean'},
		{name: 'cls', type: 'string'},
		{name: 'Year', type: 'int'},
		{name: 'Month', type: 'int'},
		{name: 'Day', type: 'string'},
		{name: 'Days', type: 'string'},
		{name: 'Sale', type: 'string'},
		{name: 'Rate', type: 'string'},
		{name: 'Commission', type: 'string'},
		{name: 'Status', type: 'string'},
		{name: 'CloseTime', type: 'string'}
	]
});


Ext.define('Setting', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'SITE_NAME', type: 'string'},
		{name: 'SITE_MASTER_EMAIL', type: 'string'},
		{name: 'TIME_FOR_LONG_CONFIRM', type: 'int'},
		{name: 'TIME_FOR_LONG_NORECEIVE', type: 'int'},
		{name: 'TIME_FOR_LONG_RECOMMENT_AUTO', type: 'int'}
	]
});

Ext.define('PageSetting', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'LOGO_IMAGE', type: 'string'},
		{name: 'BG_COLOR', type: 'string'},
		{name: 'BG_IMAGE', type: 'string'},
		{name: 'RIGHT_BG_COLOR', type: 'string'},
		{name: 'RIGHT_TEXT COLOR', type: 'string'},
		{name: 'SUCCESS_BG_COLOR', type: 'string'},
		{name: 'SUCCESS_TEXT_COLOR', type: 'string'},
		{name: 'ERROR_BG_COLOR', type: 'string'},
		{name: 'ERROR_TEXT_COLOR', type: 'string'},
		{name: 'INFO_BG_COLOR', type: 'string'},
		{name: 'INFO_TEXT_COLOR', type: 'string'},
		{name: 'HOME_WELCOME_IMAGE', type: 'string'},
		{name: 'HOME_HELLO_IMAGE1', type: 'string'},
		{name: 'HOME_HELLO_IMAGE2', type: 'string'},
		{name: 'HOME_HELLO_IMAGE3', type: 'string'},
		{name: 'HOME_HELLO_IMAGE4', type: 'string'},
		{name: 'HOME_HELLO_IMAGE5', type: 'string'},
		{name: 'HOME_HELLO_IMAGE6', type: 'string'},
		{name: 'HOME_HELLO_IMAGE7', type: 'string'},
		{name: 'HOME_HELLO_IMAGE8', type: 'string'},
		{name: 'HOME_HELLO_IMAGE9', type: 'string'},
		{name: 'HOME_HELLO_IMAGE1_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE2_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE3_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE4_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE5_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE6_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE7_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE8_URL', type: 'string'},
		{name: 'HOME_HELLO_IMAGE9_URL', type: 'string'},
		{name: 'HOME_LEFT_HINT', type: 'string'},
		{name: 'HOME_CART_HINT', type: 'string'},
		{name: 'HOME_ENCOURAGE_TITLE', type: 'string'},
		{name: 'HOME_ENCOURAGE', type: 'string'},
		{name: 'HELP_PAGE', type: 'string'},
		{name: 'CONTACT_PAGE', type: 'string'},
		{name: 'ABOUT_US_PAGE', type: 'string'},
		{name: 'LINK_PAGE', type: 'string'},
		{name: 'FAQ_PAGE', type: 'string'},
		{name: 'BUSINESS_PAGE', type: 'string'},
		{name: 'JOIN_PAGE', type: 'string'},
		{name: 'jifenshuoming_PAGE', type: 'string'},
		{name: 'dingleshuoming_PAGE', type: 'string'},
		{name: 'fuwuxieyi_PAGE', type: 'string'},
		{name: 'anquan_PAGE', type: 'string'},
		{name: 'RESTAURANT_CONTACT_EMAIL', type: 'string'},
		{name: 'RESTAURANT_CONTACT_PHONE', type: 'string'},
		{name: 'PRESS_CONTACT_EMAIL', type: 'string'},
		{name: 'PRESS_CONTACT_PHONE', type: 'string'},
		{name: 'BUSINESS_CONTACT_EMAIL', type: 'string'},
		{name: 'BUSINESS_CONTACT_PHONE', type: 'string'}
	]
});

//打印机数据模型
//商家名称-城市位置-打印机ID-绑定卡号-状态显示
Ext.define('printorModel', {
	extend: 'Ext.data.Model',
	fields: [
	    {name: 'did', type: 'int'},
		{name: 'shopName', type: 'string'},
		{name: 'shopId', type: 'int'},
		{name: 'cityName', type: 'string'},
		{name: 'cityId', type: 'int'},
		{name: 'deviceId', type: 'string'},
		{name: 'simNum', type: 'string'},
		{name: 'state', type: 'string'}
	]
});
//用于打印设备添加的 餐馆的Model
Ext.define('shopModel', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'rid', type: 'int'},
		{name: 'rname', type: 'string'}
	]
});
//用与打印设备添加的城市Model
Ext.define('cityModel', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'cid', type: 'int'},
		{name: 'cname', type: 'string'}
	]
});

Ext.define('gift', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'lpName', type: 'string'},
		{name: 'lpImgPath', type: 'string'},
		{name: 'lpScore', type: 'int'},
		{name: 'lpCount', type: 'int'},
		{name: 'lpDes', type: 'string'}
	]
});
Ext.define('giftConvertRecord', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'convertId', type: 'int'},
		{name: 'customName', type: 'string'},
		{name: 'lpName', type: 'string'},
		{name: 'address', type: 'string'},
		{name: 'phone', type: 'string'},
		{name: 'notice', type: 'string'},
		{name: 'createTime', type: 'string'},
		{name: 'endTime', type: 'string'},
		{name: 'status', type: 'string'}
	]
});

Ext.define('scoreReg', {
	extend: 'Ext.data.Model',
	fields: [
	//	{name: 'DINGCAN', type: 'string'},
		{name: 'dingcanscore', type: 'int'},
		//{name: 'PINGLUN', type: 'string'},
		{name: 'pinglunscore', type: 'int'},
		{name: 'tip1', type: 'string'},
		{name: 'tip2', type: 'string'}
	]
});
Ext.define('EmailSetting', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'email', type: 'string'},
		{name: 'fromName', type: 'string'},
		{name: 'password', type: 'string'},
		{name: 'smtp', type: 'string'},
		{name: 'user', type: 'string'}
	]
});


Ext.define('emailtemplate', {
	extend: 'Ext.data.Model',
	fields: [
		{name: 'id', type: 'int'},
		{name: 'subject', type: 'string'},
		{name: 'content', type: 'string'},
		{name: 'status', type: 'int'}
	]
});

