(function($){
	$.fn.isSidebarSearch = function() {
		var _root = $(this);
		var _input = $('#sidebar_search_box');
		var _clearButton = $('#sidebar_search_box_clear');
		var _class = {
			onType: function() {
				var query = $('#sidebar_search_box').val();
				if (query == '') {
					$('#content').removeClass('searching').removeClass('restaurant_hit').removeClass('dish_hit');
					$('#search_empty_toc').hide();
					_clearButton.css('visibility', 'hidden');
				} else {
					$('#content').addClass('searching');
					_clearButton.css('visibility', 'visible');
				}
				var queryArray = query.split(/\s+/);
				var restaurantHit = false;
				var dishHit = false;
				for (var i = 0; i < queryArray.length; i++) {
					var query = queryArray[i].toLowerCase().replace('（', '(').replace('）', ')');
					var data = $('#live_search_data').val();
					jsonData = $.parseJSON(data);
					var restaurantList = $('#restaurant_list>li.restaurant');
					for (var i2 = 0; i2 < restaurantList.size(); i2++) {
						var element = $(restaurantList[i2]);
						element = $(element);
						var id = element.data('id');
						var dishKeywords = element.find('ul.dishes').text();
						dishKeywords = dishKeywords.toLowerCase();
						var restaurantStaple = element.data('staple');
						var stapleKeywords = restaurantStaple.toLowerCase();
						var restaurantName = element.data('name');
						var restaurantTel = element.data('tel');
						var restaurantKeywords = restaurantName + ' ' + restaurantTel;
						restaurantKeywords = restaurantKeywords.toLowerCase();
						
						if (restaurantName == query) {
							$('#toc_restaurant_' + id).addClass('exactly_restaurant_match');
							element.addClass('exactly_restaurant_match');
							restaurantHit = true;
							continue;
						} else {
							$('#toc_restaurant_' + id).removeClass('exactly_restaurant_match');
							element.removeClass('exactly_restaurant_match');
						}
						if (dishKeywords.indexOf(query) >= 0) {
							$('#toc_restaurant_' + id).removeClass('restaurant_match').addClass('restaurant_dish_match');
							element.removeClass('restaurant_match').addClass('restaurant_dish_match');
							var dishList = element.find('li.dish');
							for (var i3 = 0; i3 < dishList.size(); i3++) {
								dish = $(dishList[i3]);
								if (dish.hasClass('regular_dish')) {
									continue;
								}
								var dishKeywords = dish.data('name') + ' ' + dish.data('price');
								dishKeywords = dishKeywords.toLowerCase();
								if (dishKeywords.indexOf(query) >= 0) {
									dish.addClass('search_show_dish');
								} else {
									dish.removeClass('search_show_dish');
								}
							}
							dishHit = true;
						} else if (restaurantKeywords.indexOf(query) >= 0) {
							$('#toc_restaurant_' + id).removeClass('restaurant_dish_match').addClass('restaurant_match');
							element.removeClass('restaurant_dish_match').addClass('restaurant_match');
							element.find('li.search_show_dish').removeClass('search_show_dish');
							restaurantHit = true;
						} else if (stapleKeywords.indexOf(query) >= 0) {
							$('#toc_restaurant_' + id).removeClass('restaurant_dish_match').addClass('restaurant_match');
							element.removeClass('restaurant_dish_match').addClass('restaurant_match');
							element.find('li.search_show_dish').removeClass('search_show_dish');
							restaurantHit = true;
						} else {
							$('#toc_restaurant_' + id).removeClass('restaurant_match').removeClass('restaurant_dish_match');
							element.removeClass('hidden_restaurant').removeClass('restaurant_dish_match');
						}
					}
				}
				if (dishHit) {
					$('#content').removeClass('restaurant_hit').addClass('dish_hit');
					$('#search_empty_toc').hide();
				} else if (restaurantHit) {
					$('#content').removeClass('dish_hit').addClass('restaurant_hit');
					$('#search_empty_toc').hide();
				} else {
					$('#content').removeClass('restaurant_hit').removeClass('dish_hit');
					$('#search_empty_toc').show();
				}
			},
			focusInput: function() {
				_input.focus();
			},
			clearSearchBox: function() {
				_input.val('');
				$('#content').removeClass('searching').removeClass('dish_hit').removeClass('restaurant_hit');
				_clearButton.css('visibility', 'hidden');
			}
		};
		_input.bind('keyup paste', _class.onType);
		_clearButton.bind('click', _class.clearSearchBox);
		//setTimeout(_class.focusInput, 50);
	};
	$(function(){
		$('#sidebar_search').isSidebarSearch();
	});
})(jQuery);
