(function($){
	$.fn.slideLeft = function(callback) {
		var _root = $(this);
		var _class = {
			root: _root,
			popoverBody: _root.firstParent('.popover_body'),
			step: _root.firstParent('.popover_body').width(),
			outer: $('.col2_outer'),
			currentCityUrl: _root.firstParent('.popover_body').find('li.current_city').data('url'),
			animate: function() {
				_class.root.each(function() {
					$(this).animate({
						'left':'-='+_class.step
					}, 300, function() {
						_class.outer.css({
							'overflow-y':'auto',
							'overflow-x':'hidden'
						});
						callback();
					});
				});
			},
			preHideShow: function() {
				$('.col2_outer').hide();
				$('.col2_outer.'+_class.currentCityUrl).show();
			}
		};
		function init() {
			_class.root.data('class', _class);
			_class.preHideShow();
			_class.animate();
		}
		init()
		return _class;
	};
	$.fn.slideRight = function() {
		var _root = $(this);
		var _class = {
			root: _root,			
			popoverBody: _root.firstParent('.popover_body'),
			step: _root.firstParent('.popover_body').width(),
			outer: $('.col2_outer'),
			animate: function() {
				_class.outer.css({
					'overflow':'hidden'
				});
				_class.root.each(function() {
					$(this).animate({
						'left':'+='+_class.step
					}, 300);
				});
			}
		};
		function init() {
			_class.root.data('class', _class);
			_class.animate();
		}
		init();
		return _class;
	}
	$.fn.isAreaSelector = function() {
		var _root = $(this);
		var _class = {
			root: _root,
			mapCanvas: $('#map_canvas').data('class'),
			toggle: function() {
				if ($('#toolbar_area_list').is(':visible')) {
					_class.hide();
				} else {
					_class.show();
				}
			},
			onClickBackButton: function(event) {
				_class.root.find('.col1').slideRight();
				_class.root.find('.col2_outer').slideRight();
				_class.root.find('a.popover_back_button').hide();
				_class.root.find('.popover_header_title').html('在哪座城市?');
//				$.post('/settings/set', {name:'areaSelectorCol', value:'1'});
				return false;
			},
			onSelectCity: function(event) {
				var city = $(event.target);
				var latitude = city.data('latitude');
				var longitude = city.data('longitude');
				var cityUrl = city.data('url');
				var cityName = city.html();
//				$.post('/map/' + cityUrl);
				if (!city.firstParent('li').hasClass('current_city')) {
					_class.mapCanvas.setCenter(latitude, longitude);
				}
				_class.root.find('.current_city').removeClass('current_city');
				_class.root.find('li.' + cityUrl).addClass('current_city');
				_class.root.find('.current_city_col2').removeClass('current_city_col2');
				_class.root.find('.col2_outer.' + cityUrl).addClass('current_city_col2');
				_class.root.find('.col1').slideLeft(_class.helpIe7);
				_class.root.find('.col2_outer').slideLeft(_class.helpIe7);
				_class.root.find('ul.' + cityUrl).show();
				_class.root.find('a.popover_back_button').show();
				_class.root.find('.popover_header_title').html(cityName);
				$('#map_area_search_city').val(cityName);
				$('#area_selector_toggle').html(cityName);
				return false;
			},
			onSelectArea: function(event) {
				_class.hide();
				var area = $(event.target);
				var areaUrl = area.data('url');
				var latitude = area.data('latitude');
				var longitude = area.data('longitude');
				_class.mapCanvas.setCenter(latitude, longitude);
				if (areaUrl) {
					var cityUrl = area.firstParent('ul').data('city');
//					$.get('/map/' + cityUrl + '/' + areaUrl);
				}
				return false;
			},
			create: function() {
				var html = $('#area_list_prototype').html();
				areaList = $(html).attr('id', 'toolbar_area_list');
				areaList.appendTo(_class.root);
				areaList.find('.col1 a').click(_class.onSelectCity);
				areaList.find('.col2 a').click(_class.onSelectArea);
				areaList.find('a.popover_back_button').bind('click', _class.onClickBackButton);
				_class.helpIe7();
			},
			show: function() {
				var areaList = $('#toolbar_area_list');
				if (areaList.size() > 0) {
					areaList.show();
				} else {
					_class.create();
				}
				_class.onMapResize();
			},
			helpIe7:  function() {
				if ($('body.ie7').size() > 0) {
					_class.onMapResize();
					if (_class.root.find('.col2_outer').height() < _class.root.find('.current_city_col2 .col2').height()) {
						_class.root.find('.col2_outer').css({'overflow-y':'scroll'});
					}
				}
			},
			hide: function(event) {
				if (event && $(event.target).firstParent('#area_selector').size() > 0) {
					return false;
				}
				$('#toolbar_area_list').hide();
			},
			onMapResize: function() {
				var size = $('#map_canvas').outerHeight() - 70;
				if (size > 900) {
					size = 900;
				}
				var popOverBody = _class.root.find('.popover_body');
				var col2Outer = _class.root.find('.col2_outer');
				popOverBody.height(size);
				col2Outer.height(size);
				// popOverBody.height('auto');
				// if (popOverBody.outerHeight() > size) {
				// 	popOverBody.height(size);
				// }
			}
		};
		function init() {
			_class.root.data('class', _class);
			$('#area_selector_toggle').click(_class.toggle);
			$('html').click('click', _class.hide);
			//$('#map_canvas').bind('map_clicked', _class.hide);
		}
		init();
		return _class;
	};
})(jQuery);
