(function($){
	var mapCanvas;
	var mapSearch;
	var areaSelector;
	function init() {
		mapCanvas = $('#map_canvas').isMapCanvas();
		mapSearch = $('#map_search').isMapSearchForm('#map_canvas', {
			onRestaurantClick: onRestaurantClick,
			beforeBoundsSearch: beforeBoundsSearch
		});
		try {
			areaSelector = $('#area_selector').isAreaSelector();
			$('#welcome_dismiss_btn').click(function(){
				$('#welcome_outer').remove();
				areaSelector.show();
			});
		} catch(e){}
		$('#map_zoom_in').click(mapCanvas.zoomIn);
		$('#map_zoom_out').click(mapCanvas.zoomOut);
		if (!$('body').hasClass('ie8')
				&& !$('body').hasClass('ie9')
				&& !$('body').hasClass('safari')
				&& !$('body').hasClass('firefox')
				&& !$('body').hasClass('opera')) {
			$.preloadImage('images/poof.png');
		}
	}
	function getRestaurantCallback(response) {
		var restaurantSneak = $('#restaurant_sneak');
		if (restaurantSneak.size()==0) {
			setTimeout(function(){getRestaurantCallback(response)}, 10);
		}
		var mapCanvas = $('#map_canvas').data('class');
		var json = response['json'];
		var html = response['html'];

		function addEffect() {
			// jump
			var mozTransformX = 0;
			var mozTransformY = 0;
			if ($('body').hasClass('firefox')) {
				var mozTransform = $('#restaurant_sneak').parent().parent().parent().parent().css('-moz-transform');
				if (mozTransform.indexOf('matrix(') > -1) {
					mozTransformX = mozTransform.replace(/matrix\(\d+,\s*\d+,\s*\d+,\s*\d+,\s*(\-?\d+)px,\s*\-?\d+px\)/, '$1');
					mozTransformY = mozTransform.replace(/matrix\(\d+,\s*\d+,\s*\d+,\s*\d+,\s*\-?\d+px,\s*(\-?\d+)px\)/, '$1');
					mozTransformX = parseInt(mozTransformX);
					mozTransformY = parseInt(mozTransformY);
				}
			}
			function changeCount() {
				var countSpan = $('#fav_restaurants_count');
				var count = parseInt(countSpan.html());
				$('#fav_restaurants_count').html(count + 1);
				if (count == 9) {
					countSpan.removeClass('badge_for_1').addClass('badge_for_2')	
				} else if (count == 99) {
					countSpan.removeClass('badge_for_2').addClass('badge_for_3')	
				}
			}
			if ($('body.ie6').size() >0) {
				changeCount();
			} else {
				var addButton = $('#add_id_' + json['id']);
				var realLeft = parseInt(addButton.offset().left) + mozTransformX;
				var realTop = parseInt(addButton.offset().top) + mozTransformY;
				$('#container').append('<div class="add_shadow" style="position:absolute;'
						+ 'left:' + realLeft + 'px;top:' + realTop + 'px" id="add_shadow_'
						+ json['id'] + '"></div>');
				var targetX = $('#fav_restaurants_count').offset().left;
				var targetY = $('#fav_restaurants_count').offset().top;
				var topTargetY = -80;
				$('#add_shadow_' + json['id']).parabola(100, targetX, targetY,topTargetY, changeCount);
			}
			//$('#restaurant_search_result #restaurant_' + json['id']).addClass('added').addClass('added_' + json['id']);
			var restaurantId = json['id'];
			var pinId = 'restaurant_' + restaurantId;
			var restaurantObject = mapSearch.restaurantHash[restaurantId];
			var style = restaurantObject['closed'] ? mapCanvas.RED_DOT_TINY
					: restaurantObject['rating'] == 3 ? mapCanvas.RED_STAR
					: restaurantObject['rating'] == 2 ? mapCanvas.RED_PIN
					: mapCanvas.RED_DOT_TINY;
			var zIndex = restaurantObject['rating'] == 3 ? 1 : 0;
			mapCanvas.removeBubble(pinId);
			mapCanvas.removeCircle(pinId);
			mapCanvas.pin(pinId, {
				style: style,
				zIndex: zIndex
			});
		}
		function removeEffect() {
			var restaurantId = json['id'];
			var pinId = 'restaurant_' + restaurantId;
			var restaurantObject = mapSearch.restaurantHash[restaurantId];
			var style = restaurantObject['closed'] ? mapCanvas.RED_DOT_TINY
					: restaurantObject['rating'] == 3 ? mapCanvas.RED_STAR
					: restaurantObject['rating'] == 2 ? mapCanvas.RED_PIN
					: mapCanvas.RED_DOT_TINY;
			var zIndex = restaurantObject['rating'] == 3 ? 1 : 0;
			mapCanvas.removeBubble(pinId);
			mapCanvas.removeCircle(pinId);
			mapCanvas.pin(pinId, {
				style: style,
				zIndex: zIndex
			});
			var poofStep = 1;
			var favRestaurantCountElement = $('#fav_restaurants_count');
			var favRestaurantCount = favRestaurantCountElement.html();
			favRestaurantCount--;
			var poof = $('<div class="poof poof_step1"></div>').appendTo('#back_home_btn');
			favRestaurantCountElement.html(favRestaurantCount);
			if (favRestaurantCount == 9) {
				favRestaurantCountElement.removeClass('badge_for_2').addClass('badge_for_1');
			} else if (favRestaurantCount == 99) {
				favRestaurantCountElement.removeClass('badge_for_3').addClass('badge_for_2');
			}
			function poofAnimate() {
				var newPoofStep = poofStep + 1
				if (newPoofStep > 5) {
					poof.remove();
				} else {
					poof.addClass('poof_step' + newPoofStep).removeClass('poof_step' + poofStep);
					poofStep = newPoofStep;
					setTimeout(poofAnimate, 60);
				}
			}
			setTimeout(poofAnimate, 60);
			return false;
		}
		if (json['ret'] > 0) {
			restaurantSneak.html(html).attr('class', '').addClass('restaurant_sneak'+json['id']);
			restaurantSneak.find('a.fav-remove').deleteFromIndex(json['id']);
			restaurantSneak.find('a.fav-add').addToIndex(json['id']);
			restaurantSneak.find('a.fav-add').click(addEffect);
			restaurantSneak.find('a.fav-remove').click(removeEffect);
			if (json['rating'] != 1 && json['deliveryRangeMeter'] != '') {
				mapCanvas.circle('restaurant_' + json['id'],
						json['deliveryRangeMeter']);
			} else if (json['rating']!=1) {
				mapCanvas.circle('restaurant_' + json['id'], 500);
			}
		}
	}
	function onRestaurantClick(restaurantId) {
		var restaurantObject = mapSearch.restaurantHash[restaurantId];
		mapSearch.removeAllRestaurantBubble();
		var pinId = 'restaurant_' + restaurantId;
		var latitude = restaurantObject['latLng'][0];
		var longitude = restaurantObject['latLng'][1];
		var offsetVertical = restaurantObject['rating'] == 3 ? -14 : null;
		mapCanvas.bubble(pinId, {
			latitude:latitude,
			longitude:longitude,
			content:'<div id="restaurant_sneak" class="loading"></div>',
			offsetVertical: offsetVertical
		});
		var style = restaurantObject['closed'] ? mapCanvas.GOLD_DOT_TINY
				: restaurantObject['rating'] == 3 ? mapCanvas.GOLD_STAR
				: restaurantObject['rating'] == 2 ? mapCanvas.GOLD_PIN
				: mapCanvas.GOLD_DOT_TINY;
		mapCanvas.pin(pinId, {
			zIndex: 9999,
			style: style
		});
		$('#restaurant_' + restaurantId).addClass('active');
		mapSearch.currentRestaurantId = restaurantId;
		var href = $('#restaurant_bubble_trigger_' + restaurantId).attr('href');
		$.getJH(href, getRestaurantCallback);
//		$.preloadImage('images/dash_' + (new Date()).getTime() + '.gif');
	}
	function beforeBoundsSearch() {
		if ($('#map_search').data('query') == ''
				&& mapCanvas.getZoom() < 13) {
			mapSearch.clearRestaurants();
			$('#map_canvas_left').addClass('disabled');
			$('#restaurant h3').html('为方便你快速找到位置，餐厅暂不显示');
			return false;
		} else {
			$('#map_canvas_left').removeClass('disabled');
			$('#restaurant h3').html('地图上的餐厅：');
		}
	}
	if ($.browser.msie && parseInt($.browser.version) < 9) {
		$(window).load(init);
	} else {
		$(init);
	}
})(jQuery);
