
/*!
 * Name: fav_restaurants.add_delete.js
 **/
/**
 * Usage:
 * 
 * function addFavCallback(event, restaurantId, responseObject) { ... }
 * function removeFavCallback(event, restaurantId, responseObject) { ... }
 *
 * $('body').bind('add_fav', addFavCallback);
 * $('body').bind('remove_fav', removeFavCallback);
 *
 */
(function($){
	$.fn.addToIndex = function(id){
		return this.each(function(){
			var self = $(this);
			self.bind('click',function(){
				self.firstParent('div').addClass('loading');
				var url = self.attr('href');
				if (!url) {
					return;
				}
				$.getJH(url,function(data){
					if(data.json['ret']==1){
						$('.restaurant'+id).addClass('added').addClass('added_'+id);
						$('body').trigger('add_fav', [id, data]);
					}
					var saveStatus = data.json['saveStatus'];
					if(saveStatus==1){
						//success
					}
					else if(saveStatus==2){
						//existed
					}
					self.firstParent('div').removeClass('loading');
				});	
				return false;
			});
		});
	};
	$.fn.deleteFromIndex = function(id){
		var self = $(this);
		return this.each(function(){
			self.bind('click',function(){
				//self.deleteFromIndex(id);
				self.firstParent('div').addClass('loading');
				var url = self.attr('href');
				if (!url) {
					url = "favrestaurants_remove.php?id=" + id;
				}
				$.getJH(url,function(data){
					if(data.json['ret']==1){
						$('body').trigger('remove_fav', [id, data]);
					}
					$('.added_'+id).removeClass('added').removeClass('added_'+id);
					self.firstParent('div').removeClass('loading');
				});	
				/*
				// for map page
				var countSpan = $('#fav_restaurants_count');
				if (countSpan) {
					var count = parseInt(countSpan.html());
					$('#fav_restaurants_count').html(count - 1);
					if (count == 10) {
						countSpan.removeClass('badge_for_2').addClass('badge_for_1');
					} else if (count == 100) {
						countSpan.removeClass('badge_for_3').addClass('badge_for_2');
					}
				}
				*/
				return false;
			});
		});
	};
})(jQuery);
