/*!
 * Name: header_menu.js
 **/
(function($){
	$.fn.isHeaderMenu = function() {
		this.each(function(){
			var root = $(this),
				triggerButton,
				menu;

			function showMenu(event) {
				$('#header .header_menu_outer').trigger('hideMenu');
				if (triggerButton.hasClass('clicked')) {
					return;
				}
				triggerButton.addClass('clicked');
				menu.show();
				$('html').one('click', bodyClick);
				triggerButton.one('click', hideMenu);
				return false;
			}

			function hideMenu() {
				triggerButton.removeClass('clicked');
				menu.hide();
				bindTriggerButton();
				return false;
			}

			function bodyClick(event) {
				hideMenu();
			}

			function bindTriggerButton() {
				triggerButton.one('click', showMenu);
			}

			function init() {
				if (root.size()==0) {
					return;
				}
				triggerButton = root.children('a');
				triggerButton.attr('href', 'javascript:void(0)');
				menu = root.children('.header_menu');
				bindTriggerButton();
				root.bind('hideMenu', hideMenu);
			}
			init();
		});
	};
	
	function dismissCityHint() {
		var href = $('#city_hint_dismiss').attr('href');
		if(href) { //by jumbo
			$('#city_hint').fadeOut('fast', function(){$('#city_hint').remove()});
			$.get(href);
		}
	}
	$.fn.isCityItem = function() {
		var root = $(this);
		function clickCallback() {
			dismissCityHint();
			var target = $(this);
			if (target.firstParent('.city').hasClass('current')) {
				root.trigger('hideMenu');
				return false;
			}
		}
		root.click(clickCallback);
	};
	$(function() {
		$('#header .header_menu_outer').isHeaderMenu();
		$('#city_header').isHeaderMenu();
		$('#city_header a').isCityItem();
		$('#city_hint_dismiss').click(function(){dismissCityHint();return false;});
	})
})(jQuery);
