/*!
 * Name: jquery.map.js
 **/
(function($){
	$.fn.googleMap = function(latitude, longitude, zoom, admin) {
		var latLng = new google.maps.LatLng(latitude, longitude);
		var browserSupportFlag =  new Boolean();
		var styles = (admin) ? null : [
			{
				featureType: "poi",
				elementType: "labels",
				stylers: [
					{ visibility: "off" }
				]
			}
		];
		var myOptions = {
			zoom: zoom?zoom:15,
			center: latLng,
			scrollwheel:false,
			//mapTypeControl: false,
			//navigationControl: false,
			streetViewControl: false,
			navigationControlOptions: {position:google.maps.ControlPosition.TOP_LEFT, style:google.maps.NavigationControlStyle.SMALL},
			//styles: styles,
			//mapTypeId: google.maps.MapTypeId.TERRAIN
			mapTypeId: google.maps.MapTypeId.ROADMAP
			//mapTypeId: google.maps.MapTypeId.SATELLITE
		};
		for (var i = 0; i < this.length; i++) {
			var map = new google.maps.Map(this[i], myOptions);
			$(this[i]).data('map',map);
		}
		return $(this[0]).data('map');
	};
	/*
	$.fn.pin = function(options) {
		return this.each(function(element){
			var map = $(element).data('map');
			var latLng = new google.maps.LatLng(options['latitude'],options['longitude']);
			var mapsOptions = {
				position: latLng,
				map:map
			};
			if (options['title']) {
				mapOptions['title'] = options['name'];
			}
			if (options['images']) {
				mapOptions['icon'] = options['images'];
			}
			var marker = new google.maps.Marker(mapOptions);
		}
	};
	*/
})(jQuery);
