<?php
require_once 'inc/functions.php';

if( !isset($_SESSION['session_customid']) ){
	$_SESSION['session_login_from_orders'] = 1; 
	header("Location: login.php");
	exit;
}

$orders = parse_orders();

include 'header_account.php';
?>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.order_bubble.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/common.steps_nav.css"/>	
<script src="js/orders.create.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
document.title = "<?php echo $_SESSION['session_Setting_SITE_NAME']; ?> / 创建订单";
</script>
<style type="text/css">
#spring_festival_notice {
	background:#ffc;
	border:1px solid #eeb;
	padding:5px 12px;
	font-size:12px;
	margin-bottom:10px;
	color:#311c1c;
	border-radius:5px;
}
</style>

<div class="columns create_order">
<div class="inner_columns">
<div class="left">
	<div id="content">
		<div id="order_steps_nav" class="steps_nav">
			<ol class="nav">
				<li class="step_1 current"><a href="orders_create.php"><span></span>创建订单</a></li>
				<li class="step_2 next"><i></i><span></span>等待送餐上门</li>
	
				<li class="arrow next"><i></i><span></span>收到送餐，完成</li>
			</ol>
		</div>
		<div class="cart">
			<?php if(empty($orders)) { ?>
			<div class="no_orders">
				<h2>暂时没有需要处理的订单。</h2>
			</div>
			<?php } 
			 else {
			 	 foreach($orders as $order) {
			 	 $isBusiness=isBusiness($order["restaurant"]['ID']);
					$img='';
					if(!$isBusiness){
						$img='<div class="tel"><img src="images/restaurant_not_in_opening_time_icon.gif"/></div>'. "\n";;
					} 
					
			?>
			<div class="order_bubble_arrow"></div>
			<form id="the_from_<?php echo $order["restaurant"]['ID'];?>" class="order_bubble restaurant_form create_order_form" action="orders_drop.php" method="post">
				<input type="hidden" value="<?php echo $order["restaurant"]['ID']; ?>" name="restaurantId" />
				<input type="hidden" value="<?php echo $isBusiness?'1':'0'; ?>" id="is_business_<?php echo $order["restaurant"]['ID'];?>" />
				<input type="hidden" value="<?php echo $order["restaurant"]['Name']; ?>" name="restaurant" />
				<input type="hidden" value="1" name="takeout" />
				<div class="meta vcard">
					<h2 class="name"><span><?php echo $order["restaurant"]["Name"]; ?></span></h2>
					<?php 
						
						if(!$isBusiness){
							$businessTime= getBusinessHour($order["restaurant"]['ID']);
							?>
								<span class="comment"><?php echo '该餐厅不在营业时间段'.$businessTime; ?></span>
							<?php
						}else{
							?>
							<span class="comment"><?php echo $order["restaurant"]["Notice"]; ?></span>
							<?php
						}
					?>
					
					
					<span class="tel"><?php echo $order["restaurant"]["Telphone"]; ?></span>
					<span class=""><?php echo $img; ?></span>
					<?php if(!empty($order["restaurant"]["SaleAd"])) { ?>
						<div class="sale_ad"><?php echo $order["restaurant"]["SaleAd"]; ?></div>
					<?php } ?>
				</div>
				<table class="cart_cols">
					<tr>
						<td class="dish_col">
							<h3 class="your_dish_title">您的餐饮：</h3>
							<ul class="dish_list">
								<?php foreach($order["dish_list"] as $dish) {?>
								
								<li class="dish">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name"><?php echo $dish['Name'] ?></span>
											<span class="dish_count  badge_for_<?php echo $dish['Count']>99 ? 3 : ($dish['Count']>9 ? 2 : 1);  ?>"><?php echo $dish['Count']; ?></span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $dish['Price'] ?></span>
										</div>
										<input type="hidden" value="<?php echo $dish['ID'] ?>" name="dishes[]" />
										<input type="hidden" value="<?php echo $dish['Name'] ?>" name="dishNames[]" />
										<input type="hidden" value="<?php echo $dish['Price'] ?>" name="dishPrices[]" />
										<input type="hidden" value="<?php echo $dish['Count']; ?>" name="count[]" />	
									</div>
								</li>
								<?php } ?>
								<li class="dish total">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name">合计：</span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $order["total"]; ?></span>
										</div>
									</div>
								</li>
							</ul>
						</td>
						<td class="address_col">
							<table>
								<tr>
									<th>
										<label>您的手机：</label>
									</th>
									<td class="mobile_number_outer lift">
										<div class="sth_else">
											<input type="text" name="mobileNumber" class="text mobile_number" id="mobile_number" value="<?php echo $order["mobile"];?>"/>
										</div>
										<div class="form_hint">
											如有必要，稍后我们会给您发一条短信
										</div>
									</td>
								</tr>
								<tr>
									<th class="addresses_old_title">
										<label>详细地址：</label>
										<div class="my_addresses">
										</div>
									</th>
									<td>
										<div class="addresses_old  about_old">
											<?php foreach($order["addresses"] as $i => $address) { ?>
											<p>
												<input type="radio" <?php echo $i==0 ? 'checked="checked" ' : ''; ?> value="<?php echo $address['ID'];?>" id="address_old_<?php echo $address['ID'];?>" name="addressOld">
												<label for="address_old_<?php echo $address['ID'];?>"><?php echo $address['Address'];?></label>
											</p>
											<?php } ?>
										</div>
										<div class="address_new">
											<div class="radio_wrapper" style="float:left">
												<input type="radio" name="addressOld" value="" style="display:<?php echo empty($order["addresses"])? '':'none'?>" <?php echo empty($order["addresses"])? ' checked="checked" ' : ''; ?> class="new_address_radio"/>
											</div>
											<textarea name="address"  class="order_address" rows="2" cols="20" style="display:<?php echo empty($order["addresses"])? '':'none'?>;"></textarea>
											<div class="form_hint" style="display:<?php echo empty($order["addresses"])? '':'none'?>;">请尽可能详细填写</div>
											<div class="address_new_title">
												(<a href="custom_addresses.php">编辑上述地址</a>
												<span class="order_or">或者</span>
												<a href="javascript:void(0)" class="add_new_address">添加新地址</a>)
											</div>
										</div>
									</td>
								</tr>
								<tr>
									<th class="say_sth">
										<label>餐饮要求：</label>
									</th>
									<td>
										<div class="notes">
											<textarea name="notes"  class="order_notes" rows="2" cols="20"></textarea>
										</div>
										<div class="form_hint_long">如果菜品有大份/小份选择，请在这里注明。<br/>添加上您的姓氏和称谓会更便于餐厅联系。</div>
									</td>
								</tr>
								<tr>
									<th></th>
									<td>
										<?php if($order["less_than_minmoney"]) { ?>
										<div class="create_order_warning">
											未达到起送金额，确定下单？
										</div>
										<?php } ?>
										<?php if(empty($order["restaurant"]['Takeout'])) { ?>
										<div class="create_order_warning">
											该餐馆不支持送餐上门，您可以选择到店消费，有优惠哦！
										</div>
										<?php } ?>
										<div class="submit create_order_form_submit">
										<?php if(empty($order["restaurant"]['Takeout'])) { ?>
											<input class="btn warn sub_btn" type="button" data-resId="<?php echo $order["restaurant"]['ID'];?>" value="到店消费" />
										<?php } else { ?>
											<input class="btn warn sub_btn" data-resId="<?php echo $order["restaurant"]['ID'];?>" type="submit" value="确认订单，提交" />
										<?php } ?>
											<input onclick="window.location='orders_delete.php?restaurantid=<?php echo $order["restaurant"]["ID"]; ?>'" class="btn delete" type="reset" value="删除" />
										</div>
									</td>
								</tr>
							</table>
							<script type="text/javascript">
								$('.sub_btn').click(function(event){
									var resId=$(this).attr('data-resId');
									var isBusiness=$('#is_business_'+resId).val()=='1';
									if($(this).attr('type')=='button'){//转到 进店消费
										if(isBusiness){
											window.location='orders_in.php';
											}else{
												$('#notifications').html('<div class="flash_notification error">该餐厅不在营业中</div>');
													return ;
												}
									
											}else{//直接提交
												if(isBusiness){
													$('#the_from_'+resId).submit();
													}else{
														alert('该餐厅不在营业中');
														event.preventDefault();  
														return false;
														}
											
												}
									
									//window.location='orders_in.php'
												
									});
							</script>
						</td><!--address_col-->
					</tr>
				</table><!--cart_cols-->
			</form>
			<?php }  }?>
		</div>
	</div>
</div>
<div class="right">
	<div id="side">
		<div class="faq">
			<div class="one_item first">
				<div class="q">
					<span>Q：我的餐饮多长时间能送到？</span>
				</div>
				<div class="a">
					<span>A：平均送餐时间大概在<span>40</span>分钟左右，非常快和非常慢的餐厅我们都会特别注明。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>Q：<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责送餐吗？</span>
				</div>
				<div class="a">
					<span>A：餐品均由餐厅配送。<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责为您收集附近尽可能多和准确的外卖菜单。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：我一直没收到餐饮怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们每20分钟会帮你联系餐厅催餐，您也可以点击“请帮我催一下”，我们会帮您催餐并告知您催餐结果。
					</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：如果我遇到问题怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们建议您通过我的答疑提出问题，最了解情况的人员会为您解答。您也可以拨打 4006-166-555 转 0 寻求客服帮助（客服电话的工作时间是周一至周五10:00-19:00）<div style="margin-top:6px;"><a href="/support" class="btn" target="_blank">前往我的答疑</a></div>
					</span>
				</div>
			</div>
		</div>
		<p style="margin-top:1.2em">(注：暂时不提供多餐厅同订单服务，请您谅解。)</p>
	</div>
</div>
</div>
</div>
<?php include 'footer.php' ?>