<?php
require_once 'inc/functions.php';
$order = get_order_info();
include 'header_account.php';
?>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.order_bubble.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/common.steps_nav.css"/>	
<link rel="stylesheet" type="text/css" media="screen" href="css/order.progress.css"/>
<script type="text/javascript">
document.title = "<?php echo $_SESSION['session_Setting_SITE_NAME']; ?> / 当前订单";
</script>

<div class="columns my_active_orders">
<div class="inner_columns">
<div class="left">
	<div id="content">
		<div id="settings_nav" class="tab_nav">
			<ul>
				<li>
					<a href="custom_account.php">帐号密码</a>
				</li>
				<li>
					<a href="custom_mobile.php">手机号码</a>
				</li>
				<li>
					<a href="custom_addresses.php">常用地址</a>
				</li>
				<li>
					<a href="custom_support.php">我的答疑</a>
				</li>
				<li>
					<a href="custom_orders_list.php">订单历史</a>
				</li>
			</ul>
		</div>
		<div class="my_orders">
			<div class = "order_bubble" id="order_<?php echo $order['ID']; ?>">
				<div class="meta vcard">
					<h2 class="name"><span><?php echo $order['Restaurant']; ?></span></h2>
					<span class="comment order_timer" id="timer_<?php echo $order['ID']; ?>"><?php echo $order['CreateTime']; ?></span>
					<span class="tel"><?php echo $order['Telephone']; ?></span>
				</div>
				<table class="cart_cols">
					<tbody><tr>
						<td class="dish_col">
							<h3 class="your_dish_title">您的餐饮：</h3>
							<ul class="dish_list">
								<?php foreach($order['dishes'] as $dish) { ?>
								<li class="dish">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name"><?php echo $dish['Name']; ?></span>
											<span class="dish_count  badge_for_<?php echo $dish['Count']<10 ? 1 : ($dish['Count']<100 ? 2 : 3) ?>">
												<?php echo $dish['Count']; ?>
											</span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $dish['Price']; ?></span>
										</div>
									</div>
								</li>
								<?php } ?>
								<li class="dish total">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name">合计：</span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $order['total']; ?></span>
										</div>
									</div>
								</li>
							</ul>
						</td>
						<td class="address_col">
							<table>
								<tbody><tr>
									<th>
										<label>您的手机：</label>
									</th>
									<td>
										<?php echo $order['Mobile']; ?>
									</td>
								</tr>
								<tr>
									<th class="addresses_old_title">
										<label>详细地址：</label>
									</th>
									<td>
										<?php echo $order['Address']; ?>
									</td>
								</tr>
								<tr>
									<th class="say_sth">
										<label>餐饮要求：</label>
									</th>
									<td>
										<?php echo $order['Notes']; ?>
									</td>
								</tr>
							</tbody></table>
						</td><!--address_col-->
					</tr></tbody>
				</table><!--cart_cols-->
				<div class="progress_section">
					<ol class="order_progress">
					<?php foreach($order['process'] as $process) { ?>
						<li id="order_progress_<?php echo $process["id"]; ?>" class="one_order_progress <?php echo ($process["type"]>8) ? "killed_by_admin" : ""; ?>">
							<div class="time">
								<span><?php echo $process["timestamp"]; ?></span>
							</div>
							<div class="activity activity_history"><?php echo $process["activity"]; ?></div>
						</li>
					<?php } ?>
					</ol>
				</div>
			</div> <!--order_bubble-->
		</div><!--my_orders-->
	</div><!--content-->
</div><!--left-->
<div class="right">
	<div id="side">
		<div class="faq">
			<div class="one_item first">
				<div class="q">
					<span>Q：我的餐饮多长时间能送到？</span>
				</div>
				<div class="a">
					<span>A：平均送餐时间大概在<span>40</span>分钟左右，非常快和非常慢的餐厅我们都会特别注明。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>Q：<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责送餐吗？</span>
				</div>
				<div class="a">
					<span>A：餐品均由餐厅配送。<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责为您收集附近尽可能多和准确的外卖菜单。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：我一直没收到餐饮怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们每20分钟会帮你联系餐厅催餐，您也可以点击“请帮我催一下”，我们会帮您催餐并告知您催餐结果。
					</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：如果我遇到问题怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们建议您通过我的答疑提出问题，最了解情况的人员会为您解答。您也可以拨打 4000059427转 888 寻求客服帮助（客服电话的工作时间是周一至周五10:00-19:00）<div style="margin-top:6px;"><a href="/support" class="btn" target="_blank">前往我的答疑</a></div>
					</span>
				</div>
			</div>
		</div>
		<p style="margin-top:1.2em">(注：暂时不提供多餐厅同订单服务，请您谅解。)</p>
	</div>
</div>
</div>
</div>
<?php include 'footer.php' ?>