<?php
require_once 'inc/functions.php';
if( !isset($_SESSION['session_customid']) ){
	header("Location: login.php");
	exit;
}
$orders = parse_orders();
include 'header_account.php';
?>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/order.order_bubble.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="css/common.steps_nav.css"/>	
<script src="js/orders.create.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
document.title = "<?php echo $_SESSION['session_Setting_SITE_NAME']; ?> / 创建订单";
</script>
<style type="text/css">
#spring_festival_notice {
	background:#ffc;
	border:1px solid #eeb;
	padding:5px 12px;
	font-size:12px;
	margin-bottom:10px;
	color:#311c1c;
	border-radius:5px;
}
</style>

<div class="columns create_order">
<div class="inner_columns">
<div class="left">
	<div id="content">
		<div id="order_steps_nav" class="steps_nav">
			<ol class="nav">
				<li class="step_1 current"><a href="orders_in.php"><span></span>创建订单</a></li>
				<li class="step_2 next"><i></i><span></span>到店消费</li>
	
				<li class="arrow next"><i></i><span></span>完成</li>
			</ol>
		</div>
		<div class="cart">
			<?php if(empty($orders)) { ?>
			<div class="no_orders">
				<h2>暂时没有需要处理的订单。</h2>
			</div>
			<?php } 
			 else {
			 	 foreach($orders as $order) { 
			 	 	 $isBusiness=isBusiness($order["restaurant"]['ID']);
					$img='';
					if(!$isBusiness){
						$img='<div class="tel"><img src="images/restaurant_not_in_opening_time_icon.gif"/></div>'. "\n";;
					} 
			?>
			<div class="order_bubble_arrow"></div>
			<form class="order_bubble restaurant_form create_order_form" action="orders_drop.php" method="post">
				<input type="hidden" value="<?php echo $order["restaurant"]['ID']; ?>" name="restaurantId" />
				<input type="hidden" value="<?php echo $order["restaurant"]['Name']; ?>" name="restaurant" />
				<input type="hidden" value="<?php echo $isBusiness?'1':'0'; ?>" id="is_business_<?php echo $order["restaurant"]['ID'];?>" />
				<input type="hidden" value="0" name="takeout" />
				<input type="hidden" value="<?php echo $order["restaurant"]['DiscountIn']; ?>" name="discount" />
				<div class="meta vcard">
					<h2 class="name"><span><?php echo $order["restaurant"]["Name"]; ?></span></h2>
					<?php 
						if(!$isBusiness){
							$businessTime= getBusinessHour($order["restaurant"]['ID']);
							?>
								<span class="comment"><?php echo '该餐厅不在营业时间段'.$businessTime; ?></span>
							<?php
						}else{
							?>
							<span class="comment"><?php echo $order["restaurant"]["Notice"]; ?></span>
							<?php
						}
					?>
					
					<span class="tel"><?php echo $order["restaurant"]["Telphone"]; ?></span>
					<span class=""><?php echo $img; ?></span>
					<?php if(!empty($order["restaurant"]["SaleAd"])) { ?>
						<div class="sale_ad"><?php echo $order["restaurant"]["SaleAd"]; ?></div>
					<?php } ?>
				</div>
				<table class="cart_cols">
					<tr>
						<td class="dish_col">
							<h3 class="your_dish_title">您的餐饮：</h3>
							<ul class="dish_list">
								<?php foreach($order["dish_list"] as $dish) { ?>
								<li class="dish">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name"><?php echo $dish['Name'] ?></span>
											<span class="dish_count  badge_for_<?php echo $dish['Count']>99 ? 3 : ($dish['Count']>9 ? 2 : 1);  ?>"><?php echo $dish['Count']; ?></span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $dish['Price'] ?></span>
										</div>
										<input type="hidden" value="<?php echo $dish['ID']; ?>" name="dishes[]" />
										<input type="hidden" value="<?php echo $dish['Name']; ?>" name="dishNames[]" />
										<input type="hidden" value="<?php echo $dish['Price']; ?>" name="dishPrices[]" />
										<input type="hidden" value="<?php echo $dish['Count']; ?>" name="count[]" />	
									</div>
								</li>
								<?php } ?>
								<li class="dish total">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name">合计：</span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $order["total"]; ?></span>
										</div>
									</div>
								</li>
								<?php if(!empty($order["restaurant"]["DiscountIn"])) {
									 $discount_total = $order["total"] * $order["restaurant"]["DiscountIn"] / 10; ?>
								<li class="dish discount_total">
									<div class="dish_detail">
										<div class="dish_name_outer">
											<span class="dish_name">折后价：</span>
										</div>
										<div class="dish_price_outer">
											<span class="dish_price"><?php echo $discount_total; ?></span>
										</div>
									</div>
								</li>
									
								<?php } ?>
							</ul>
						</td>
						<td class="address_col">
							<table>
								<tr>
									<th>
										<label>您的手机：</label>
									</th>
									<td class="mobile_number_outer lift">
										<div class="sth_else">
											<input type="text" name="mobileNumber" class="text mobile_number" id="mobile_number" value="<?php echo $order["mobile"];?>"/>
										</div>
										<div class="form_hint">
											稍后我们会给您发一条短信
										</div>
									</td>
								</tr>
								<tr>
									<th class="addresses_old_title">
										<label>就餐时间：</label>
										<div class="my_addresses">
										</div>
									</th>
									<td>
										<div class="dinner_time">
											<p>
												<input type="radio" name="time_type" value="1" id="time_type_1_<?php echo $order["restaurant"]["ID"]; ?>" checked="checked">
												<label for="time_type_1_<?php echo $order["restaurant"]["ID"]; ?>">在<input type="text" name="time_type_1" value="20" size="3">分钟后就餐</label>
											</p>
											<p>
												<input type="radio" name="time_type" value="2" id="time_type_2_<?php echo $order["restaurant"]["ID"]; ?>" >
												<label for="time_type_2_<?php echo $order["restaurant"]["ID"]; ?>"><input type="text" name="time_type_2" value="在XX:XX后就餐" size="20"/></label>
											</p>
										</div>
									</td>
								</tr>
								<tr>
									<th class="say_sth">
										<label>餐饮要求：</label>
									</th>
									<td>
										<div class="notes">
											<textarea name="notes"  class="order_notes" rows="2" cols="20"></textarea>
										</div>
										<div class="form_hint_long">如果菜品有大份/小份选择，请在这里注明。<br/>添加上您的姓氏和称谓会更便于餐厅联系。</div>
									</td>
								</tr>
								<tr>
									<th></th>
									<td>
										<?php if($order["less_than_minmoney"]) { ?>
										<div class="create_order_warning">
											未达到起送金额，确定下单？
										</div>
										<?php } ?>
										<div class="submit create_order_form_submit">
											<input class="btn warn btn_submit" data-resId="<?php echo $order["restaurant"]['ID'];?>" type="submit" value="确认订单，提交" />
											<input onclick="window.location='orders_delete.php?restaurantid=<?php echo $order["restaurant"]["ID"]; ?>'" class="btn delete" type="reset" value="删除" />
										</div>
										<script type="text/javascript">
											$('.btn_submit').click(function(){
												var resId=$(this).attr('data-resId');
												var isBusiness=$('#is_business_'+resId).val()=='1';
												if(!isBusiness){
													$('#notifications').html('<div class="flash_notification error">该餐厅不在营业中</div>');
													return false;	
												}
												
											});
										
										</script>
									</td>
								</tr>
							</table>
						</td><!--address_col-->
					</tr>
				</table><!--cart_cols-->
			</form>
			<?php }  }?>
		</div>
	</div>
</div>
<div class="right">
	<div id="side">
		<div class="faq">
			<div class="one_item first">
				<div class="q">
					<span>Q：我的餐饮多长时间能送到？</span>
				</div>
				<div class="a">
					<span>A：平均送餐时间大概在<span>40</span>分钟左右，非常快和非常慢的餐厅我们都会特别注明。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>Q：<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责送餐吗？</span>
				</div>
				<div class="a">
					<span>A：餐品均由餐厅配送。<?php echo $_SESSION['session_Setting_SITE_NAME']; ?>负责为您收集附近尽可能多和准确的外卖菜单。</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：我一直没收到餐饮怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们每20分钟会帮你联系餐厅催餐，您也可以点击“请帮我催一下”，我们会帮您催餐并告知您催餐结果。
					</span>
				</div>
			</div>
			<div class="one_item">
				<div class="q">
					<span>
						Q：如果我遇到问题怎么办？
					</span>
				</div>
				<div class="a">
					<span>
						A：我们建议您通过我的答疑提出问题，最了解情况的人员会为您解答。您也可以拨打 4006-166-555 转 0 寻求客服帮助（客服电话的工作时间是周一至周五10:00-19:00）<div style="margin-top:6px;"><a href="/support" class="btn" target="_blank">前往我的答疑</a></div>
					</span>
				</div>
			</div>
		</div>
		<p style="margin-top:1.2em">(注：暂时不提供多餐厅同订单服务，请您谅解。)</p>
	</div>
</div>
</div>
</div>
<?php include 'footer.php' ?>