<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
	/**
	 * Authenticates a user.
	 * The example implementation makes sure if the username and password
	 * are both 'demo'.
	 * In practical applications, this should be changed to authenticate
	 * against some persistent user identity storage (e.g. database).
	 * @return boolean whether authentication succeeds.
	 */
    public $user;
	public $_id;
	public $username;
	public function authenticate()
	{   
		$student=Student::model()->find('LOWER(username)=?',array(strtolower($this->username)));
		if($student===null)
			$this->errorCode=self::ERROR_USERNAME_INVALID;
		else if(!$student->validatePassword($this->password))//调用student模型验证密码
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else
		{
			$this->_id=$student->id;
			$this->username=$student->username;
			$this->errorCode=self::ERROR_NONE;
			
            $this->setUser($student);
						
		}
		return $this->errorCode==self::ERROR_NONE;
	}
    public function getUser()
    {
        return $this->user;
    }

    public function getId()
        {
                return $this->_id;
        }

    public function getUserName()
        {
                return $this->username;
        }

    public function setUser(CActiveRecord $user)
    {
        $this->user=$user->attributes;
    }
}