<?php

class ExammanageController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column3';
	public $menu2=array();
	public $menu3=array();
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','create','update','admin','listview','totalscore','classroom_rank','grade_rank','jige'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin1'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($type,$id,$exam_id)
	{	$this->layout='//layouts/column1';
		if($type=='judge')
		{
			$this->render('view_judge',array(
				'model'=>Judge::model()->find("id='$id'"),
				'exam_id'=>$exam_id,
			));			
			Yii::app()->end();
		}
		if($type=='multi')
		{
			$this->render('view_multi',array(
				'model'=>Multichoice::model()->find("id='$id'"),
				'exam_id'=>$exam_id,
			));			
			Yii::app()->end();
		}
		if($type=='single')
		{
			$this->render('view',array(
				'model'=>Singlechoice::model()->find("id='$id'"),
				'exam_id'=>$exam_id,
			));			
			Yii::app()->end();
		}
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Exammanage;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Exammanage']))
		{
			$model->attributes=$_POST['Exammanage'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Exammanage']))
		{
			$model->attributes=$_POST['Exammanage'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{	
		$student_id=Yii::app()->user->id;
		$data=Exammanage::model()->findAll("examState=0");
		$arr_ing=$this->menu;
		$arr_re=array();
		$arr_ed=array();
		$i=$j=$k=0;
		foreach($data as $k=>$v){
			$exam_id=$v['id'];
			$data2=Score::model()->findAll("exam_id='$exam_id' and student_id='$student_id'");
			if(empty($data2))
			{	
				if($v['testtype']==3)
				{
					$id=$v['id'];
					$arr_ing[$i]['url']=array("student/exam3/exam_id/$id");
					$arr_ing[$i]['label']=$v['title'];				
				}else
				{
					$id=$v['id'];
					$arr_ing[$i]['url']=array("student/exam/exam_id/$id");
					$arr_ing[$i]['label']=$v['title'];				
				}
			}else
			{
				foreach($data2 as $k2=>$v2)
				{$id=$v['id'];
					if($v2['reexam'])
					{
						$arr_ed[$j]['url']='';
						$arr_ed[$j]['label']=$v['title'];
					}else
					{
						if($v['testtype']==3)
						{
							$arr_re[$k]['url']=array("student/exam3/exam_id/$id");
							$arr_re[$k]['label']=$v['title'];						
						}else
						{
							$arr_re[$k]['url']=array("student/exam/exam_id/$id");
							$arr_re[$k]['label']=$v['title'];	
						}
					}$j++;$k++;					
				}
			}$i++;$data2=null;
			}
			$this->menu=$arr_ing;//未考
			$this->menu2=$arr_re;//已考，可重考
			$this->menu3=$arr_ed;//历史考试
		$dataProvider=new CActiveDataProvider('Exammanage', array(
			'criteria'=>array(
				'condition'=>'examState=0',
				//'order'=>'id',
				//'with'=>array('score_exam'),
				//'alias'=>'ta',
				//'join'=>'JOIN '.Score::model()->tableName().' ta ON ta.exam_id=t.id',
				'with'=>array('score_exam'),
			),
			'pagination'=>array(
				'pageSize'=>10,
			),
		));
		$data=$dataProvider->getData();
		//print_r($data);//exit;
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Exammanage('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Exammanage']))
			$model->attributes=$_GET['Exammanage'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Exammanage::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='exammanage-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public $exam_id_;
	public function actionListview($type=null,$exam_id=null)
	{
		$this->layout='//layouts/column1';
		$student_id=Yii::app()->user->id;
		$data=Score::model()->find("student_id='$student_id' and exam_id='$exam_id'");
		if(!isset($data))
		{
			Yii::app()->user->setFlash('shutoff','未找到任何记录！');
			$this->render('shutoff');
			yii::app()->end();
		}
		$arr_single=explode(',',$data->singlechoiceError);
		$arr_multi=explode(',',$data->multichoiceError);
		$arr_judge=explode(',',$data->judgeError);
		if($type=='single')
		{	$this->exam_id_=$exam_id;
			$criteria=new CDbCriteria();
			$criteria->addInCondition('id',$arr_single); 
			$dataProvider=new CActiveDataProvider('Singlechoice',array('criteria'=>$criteria));
			$this->render('index_single',array(
				'dataProvider'=>$dataProvider,
			));
			Yii::app()->end();			
		}
		if($type=='multi')
		{	$this->exam_id_=$exam_id;
			$criteria=new CDbCriteria();
			$criteria->addInCondition('id',$arr_multi); 
			$dataProvider=new CActiveDataProvider('Multichoice',array('criteria'=>$criteria));
			$this->render('index_multi',array(
			'dataProvider'=>$dataProvider,
			'exam_id'=>$exam_id,
			));
			Yii::app()->end();
		}
		if($type=='judge')
		{	$this->exam_id_=$exam_id;
			$criteria=new CDbCriteria();
			$criteria->addInCondition('id',$arr_judge); 
			$dataProvider=new CActiveDataProvider('Judge',array('criteria'=>$criteria));
			$this->render('index_judge',array(
			'dataProvider'=>$dataProvider,
			'exam_id'=>$exam_id,
			));
			Yii::app()->end();
		}
	}
	public function actionTotalscore($exam_id=null)
	{
		$student_id=Yii::app()->user->id;
		$data=Score::model()->find("student_id='$student_id'and exam_id='$exam_id'");
		$totalScore=$data->totalScore;
		echo "document.write('$totalScore')";
	}
	public function actionClassroom_rank($exam_id=null)
	{
		$student_id=Yii::app()->user->id;
		$data=Student::model()->find("id='$student_id'");
		$classroom_id=$data->classroom_id;
		$data=Score::model()->find("student_id='$student_id'and exam_id='$exam_id'");
		$total=$data->totalScore;
		$data=Score::model()->findAll("exam_id='$exam_id' and classroom_id='$classroom_id' and totalScore>='$total'");
		$count=count($data);
		echo "document.write('$count')";;
	}
	public function actionGrade_rank($exam_id=null)
	{
		$student_id=Yii::app()->user->id;
		$data=Student::model()->find("id='$student_id'");
		$grade_id=$data->grade_id;
		$data=Score::model()->find("student_id='$student_id'and exam_id='$exam_id'");
		$total=$data->totalScore;
		$data=Score::model()->findAll("exam_id='$exam_id' and grade_id='$grade_id' and totalScore>='$total'");
		$count=count($data);
		echo "document.write('$count')";
	}
	public function actionJige($exam_id=null)
	{
		$student_id=Yii::app()->user->id;
		$data=Student::model()->find("id='$student_id'");
		$grade_id=$data->grade_id;
		$data=Score::model()->find("student_id='$student_id'and exam_id='$exam_id'");
		$total_my=$data->totalScore;
		$data=Myexam::model()->find("student_id='$student_id'and exam_id='$exam_id'");
		$total=$data->totalScore;
		if($total_my>=$total*0.6)
		{
			$jige='是';
		}else
		{
			$jige='否';
		}
		echo "document.write('$jige')";
	}
}
