<?php

class FavoritesController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2_';
	public $title='试题分类';
	//public function init()
	
	protected function beforeAction($action)
	{
        $session=new CHttpSession;
		$session->open();
		$exam_id=$session['exam_id'];
		$student_id=Yii::app()->user->id;
		if(isset($exam_id)&&isset($student_id))
		{
			$data=Invigilator::model()->find(array(
				'condition'=>"exam_id=$exam_id and student_id=$student_id",
				'select'=>'submitmark',
			));
			$an=$action->id;

			if(!$data->submitmark && ($an!='fav'))
			{
				Yii::app()->user->setFlash('shutoff','考试中，稍候访问！');
				$this->render('shutoff');return false;
				Yii::app()->end();
			}
			
		}
		return true;
	}/**/
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','create','update','fav','delete'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($type,$id)
	{	$this->layout='//layouts/column1';
		if($type=='operate')
		{
			$this->render('view_operate',array(
				'model'=>Operation::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
		if($type=='judge')
		{
			$this->render('view_judge',array(
				'model'=>Judge::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
		if($type=='multi')
		{
			$this->render('view_multi',array(
				'model'=>Multichoice::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
		if($type=='single')
		{
			$this->render('view',array(
				'model'=>Singlechoice::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Favorites;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Favorites']))
		{
			$model->attributes=$_POST['Favorites'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Favorites']))
		{
			$model->attributes=$_POST['Favorites'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($type=null)
	{
		$student_id=Yii::app()->user->id;
		$model=Favorites::model()->find("student_id='$student_id'");
		if($type=='operate')
		{
			$arr_operate=explode(',',$model->operateFavorites);
			$key=array_search($_POST['id'],$arr_operate);
			unset($arr_operate[$key]);
			$str=implode(',',$arr_operate);
			$model->attributes=array('operateFavorites'=>$str);
			if($model->save(false))
			{
				echo true;
			}		
		}
		if($type=='judge')
		{
			$arr_judge=explode(',',$model->judgeFavorites);
			$key=array_search($_POST['id'],$arr_judge);
			unset($arr_judge[$key]);
			$str=implode(',',$arr_judge);
			$model->attributes=array('judgeFavorites'=>$str);
			if($model->save(false))
			{
				echo true;
			}		
		}
		if($type=='multi')
		{
			$arr_multi=explode(',',$model->multiFavorites);
			$key=array_search($_POST['id'],$arr_multi);
			unset($arr_multi[$key]);
			$str=implode(',',$arr_multi);
			$model->attributes=array('multiFavorites'=>$str);
			if($model->save(false))
			{
				echo true;
			}
		}
		if($type=='single')
		{
			$arr_single=explode(',',$model->singleFavorites);
			$key=array_search($_POST['id'],$arr_single);
			unset($arr_single[$key]);
			$str=implode(',',$arr_single);
			$model->attributes=array('singleFavorites'=>$str);
			if($model->save(false))
			{
				echo true;
			}		
		}		
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex($type=null)
	{
		$student_id=Yii::app()->user->id;
		$data=Favorites::model()->find("student_id='$student_id'");
		
		if(!isset($data))
		{
			Yii::app()->user->setFlash('shutoff','暂无收藏，稍候访问！');
			$this->render('shutoff');
			Yii::app()->end();
		}		
		
		$arr_single=explode(',',$data->singleFavorites);
		$arr_multi=explode(',',$data->multiFavorites);
		$arr_judge=explode(',',$data->judgeFavorites);
		$arr_operate=explode(',',$data->operateFavorites);
		if($type=='single')
		{
			$criteria=new CDbCriteria();
			$criteria->addInCondition('id',$arr_single); 
			$dataProvider=new CActiveDataProvider('Singlechoice',array('criteria'=>$criteria));
		}
		if($type=='multi')
		{
			$criteria=new CDbCriteria();
			$criteria->addInCondition('id',$arr_multi); 
			$dataProvider=new CActiveDataProvider('Multichoice',array('criteria'=>$criteria));
			$this->render('index_multi',array(
			'dataProvider'=>$dataProvider,
			));
			Yii::app()->end();
		}
		if($type=='judge')
		{
			$criteria=new CDbCriteria();
			$criteria->addInCondition('id',$arr_judge); 
			$dataProvider=new CActiveDataProvider('Judge',array('criteria'=>$criteria));
			$this->render('index_judge',array(
			'dataProvider'=>$dataProvider,
			));
			Yii::app()->end();
		}
		if($type=='operate')
		{
			$criteria=new CDbCriteria();
			$criteria->addInCondition('id',$arr_operate); 
			$dataProvider=new CActiveDataProvider('Operation',array('criteria'=>$criteria));
			$this->render('index_operate',array(
			'dataProvider'=>$dataProvider,
			));
			Yii::app()->end();
		}
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Favorites('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Favorites']))
			$model->attributes=$_GET['Favorites'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Favorites::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='favorites-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionFav($id=null,$type=null)
	{
		$student_id=Yii::app()->user->id;
		if($type=='single')
		{
			$model=Favorites::model()->find("student_id=$student_id");
			if(empty($model))
			{
				$model=new Favorites();
				$str=$id;
				$model->attributes=array('singleFavorites'=>$str,'student_id'=>$student_id);
				if($model->save(false)){
					echo "收藏成功！";
				}
			}else
			{
				if(empty($model->singleFavorites)){$str=$id;}else
				{
    				//先转换成数组，看有没有
    				if(in_array($id,explode(',',$model->singleFavorites)))
                    {
                        echo "您已经收藏过此题！";Yii::app()->end();
                    }
    				$str=$model->singleFavorites.','.$id;
				
				}
				$model->attributes=array('singleFavorites'=>$str);
				if($model->update()){
					echo "收藏成功！";
				}
			
			}
		}
		if($type=='multi')
		{
			$model=Favorites::model()->find("student_id=$student_id");
			if(empty($model))
			{
				$model=new Favorites();
				$str=$id;
				$model->attributes=array('multiFavorites'=>$str,'student_id'=>$student_id);
				if($model->save(false)){
					echo "收藏成功！";
				}
			}else
			{
				if(empty($model->multiFavorites)){$str=$id;}else
				{
    				//先转换成数组，看有没有
    				if(in_array($id,explode(',',$model->multiFavorites)))
                    {
                        echo "您已经收藏过此题！";Yii::app()->end();
                    }
    				$str=$model->multiFavorites.','.$id;
				
				}
				$model->attributes=array('multiFavorites'=>$str);
				if($model->update()){
					echo "收藏成功！";
				}
			
			}		
		}
		if($type=='judge')
		{
			$model=Favorites::model()->find("student_id=$student_id");
			if(empty($model))
			{
				$model=new Favorites();
				$str=$id;
				$model->attributes=array('judgeFavorites'=>$str,'student_id'=>$student_id);
				if($model->save(false)){
					echo "收藏成功！";
				}
			}else
			{
				if(empty($model->judgeFavorites)){$str=$id;}else
				{
    				//先转换成数组，看有没有
    				if(in_array($id,explode(',',$model->judgeFavorites)))
                    {
                        echo "您已经收藏过此题！";Yii::app()->end();
                    }
    				$str=$model->judgeFavorites.','.$id;
				
				}
				$model->attributes=array('judgeFavorites'=>$str);
				if($model->update()){
					echo "收藏成功！";
				}
			
			}			
		}
		if($type=='operate')
		{
			$model=Favorites::model()->find("student_id=$student_id");
			if(empty($model))
			{
				$model=new Favorites();
				$str=$id;
				$model->attributes=array('operateFavorites'=>$str,'student_id'=>$student_id);
				if($model->save(false)){
					echo "收藏成功！";
				}
			}else
			{
				if(empty($model->operateFavorites)){$str=$id;}else
				{
    				//先转换成数组，看有没有
    				if(in_array($id,explode(',',$model->operateFavorites)))
                    {
                        echo "您已经收藏过此题！";Yii::app()->end();
                    }
    				$str=$model->operateFavorites.','.$id;
				
				}
				$model->attributes=array('operateFavorites'=>$str);
				if($model->update()){
					echo "收藏成功！";
				}
			
			}			
		}
	}
}
