<?php

class KnowledgepointController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column4';
	protected function beforeAction($action)
	{
        $session=new CHttpSession;
		$session->open();
		$exam_id=$session['exam_id'];
		$student_id=Yii::app()->user->id;
		if(isset($exam_id)&&isset($student_id))
		{
			$data=Invigilator::model()->find(array(
				'condition'=>"exam_id=$exam_id and student_id=$student_id",
				'select'=>'submitmark',
			));
			$data2=Exammanage::model()->find(array(
				'condition'=>"id=$exam_id",
				'select'=>'examMode',
			));
			if(!$data->submitmark && $data2->examMode)
			{
				Yii::app()->user->setFlash('shutoff','考试中，稍候访问！');
				$this->render('shutoff');return false;
				Yii::app()->end();
			}
						
		}
		return true;
	}
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','listview'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{	$this->layout='//layouts/column1';
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
	//分类显示知识点
	public function actionListview($cat_id)
	{	$data2=Knowledgelist::model()->findAll();
		foreach($data2 as $key=>$value)
		{$cate_id=$value['id'];
			$this->menu[]=array('label'=>$value['title'],'url'=>array("knowledgepoint/listview/cat_id/$cate_id"));
		}
		$data=Knowledgelist::model()->find("id = '$cat_id'");
		$cat_title=isset($data)?$data->title:'';
		$dataProvider =new CActiveDataProvider('Knowledgepoint',
			array('criteria' => array('select' => "*",         
                    'order' => "id desc",
                    'condition'=> "knowledgelist_id=:cat_id",
                    'params'    => array(':cat_id' =>"$cat_id"),
                
                ),
            'pagination'=>array(
                'pageSize'=>20,
                ),

            ));
		$this->render('cat_index',array(
			'dataProvider'=>$dataProvider,
			'cat_title'=>$cat_title,
		));	
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Knowledgepoint;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Knowledgepoint']))
		{
			$model->attributes=$_POST['Knowledgepoint'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Knowledgepoint']))
		{
			$model->attributes=$_POST['Knowledgepoint'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$data=Knowledgelist::model()->findAll();
		foreach($data as $key=>$value)
		{$cat_id=$value['id'];
			$this->menu[]=array('label'=>$value['title'],'url'=>array("knowledgepoint/listview/cat_id/$cat_id"));
		}
		$dataProvider=new CActiveDataProvider('Knowledgepoint');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Knowledgepoint('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Knowledgepoint']))
			$model->attributes=$_GET['Knowledgepoint'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Knowledgepoint::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='knowledgepoint-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
