<?php

class SiteController extends Controller
{
	/**
	 * Declares class-based actions.
	 */
	public $layout='//layouts/column2';
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		//选出每个班的满分和不及格的人名 group by
		//取得所有未禁用的考试
		$data_examlist=Exammanage::model()->findAll("examState=0");
		//取考试ID和满分
        $data_examid=array();
        $arr_examid=array();
        foreach($data_examlist as $k=>$v)
		{
		  $data_examid[]=$v['id'];
		  $arr_examid[]=array('exam_id'=>$v['id'],'exam_title'=>$v['title']);
		}
        $criteria=new CDbCriteria(array(
			'order'=>'exam_id desc',
			'select'=>'exam_id, totalScore',
		));
        $criteria->addInCondition('exam_id',$data_examid);
        $criteria->distinct = true;
        $data_totalscore_examid=Myexam::model()->findAll($criteria);
		$data_te=array();
        foreach($data_totalscore_examid as $k=>$v)
        {
            $data_te[]=array(
                'exam_id'=>$v['exam_id'],
                'totalScore'=>$v['totalScore'],
			);
        }
		$arr_rank=array();
		$arr_manfen=array();
		$arr_bukao=array();
		//取得所有班级的ID
		$data=Grade::model()->find("title='高二'");
		$grade_id=$data->id;
		$criteria=new CDbCriteria(array('select'=>'id','condition'=>"grade_id='$grade_id'"));
		$data=Classroom::model()->findAll($criteria);
		//$arr_classroom=CJSON::decode(CJSON::encode($data));
		foreach($data as $k=>$v)
		{
			$arr_classroom[]=$v['id'];
		}
		//print_r($arr_classroom);
		//>-------------------------------------取满分学生
        foreach($data_te as $k=>$v)//按考试列表循环
        {   $exam_id=$v['exam_id'];
			$totalScore=$v['totalScore'];
            //$exam_id=1;
		    //$totalScore=159;
			//得到考试标题
			foreach($arr_examid as $k3=>$v3)
			{
				if($v3['exam_id']==$exam_id)
				$exam_title=$v3['exam_title'];
			}
            $criteria2=new CDbCriteria(array(
                'condition'=>"exam_id='$exam_id' and totalScore='$totalScore'",
    			'select'=>'student_id,classroom_id,totalScore',
                'with'=>array('student_fullname','classroom_title'),
    		)); 
            //$criteria2->group='t.classroom_id';
 
            $data_1=Score::model()->findAll($criteria2); 
			//print_r(CJSON::decode(CJSON::encode($data_1)));exit;
			foreach($arr_classroom as $k=>$v)
			{
				foreach($data_1 as $k2=>$v2)
				{
					if($v==$v2['classroom_id'])
					{	$class_title=$v2['classroom_title']['title'];
						$arr_rank[$exam_title][$class_title]['manfen'][]=$v2['student_fullname']['fullname'];
						//$arr_manfen[$exam_id][$class_title][]=$v2['student_fullname']['fullname'];
					}
					//echo $v2['classroom_title']['title'];
					//echo $v2['classroom_id'];
				}
			}
			//$arr_manfen=array();
        }//print_r($arr_manfen);
		//取满分学生结束
		//>----------------------------------------------取着生学生
        foreach($data_te as $k=>$v)
        {   $exam_id=$v['exam_id'];
			$bujige=$v['totalScore']*0.8;
            //$exam_id=1;
		    //$totalScore=159;
			//得到考试标题
			foreach($arr_examid as $k3=>$v3)
			{
				if($v3['exam_id']==$exam_id)
				$exam_title=$v3['exam_title'];
			}		
            $criteria2=new CDbCriteria(array(
                'condition'=>"exam_id='$exam_id' and totalScore<='$bujige'",
    			'select'=>'student_id,classroom_id,totalScore',
                'with'=>array('student_fullname','classroom_title'),
    		)); 
            //$criteria2->group='t.classroom_id';
 
            $data_1=Score::model()->findAll($criteria2);
			//print_r(CJSON::decode(CJSON::encode($data_1)));exit;
			foreach($arr_classroom as $k=>$v)
			{
				foreach($data_1 as $k2=>$v2)
				{
					if($v==$v2['classroom_id'])
					{	$class_title=$v2['classroom_title']['title'];
						$arr_rank[$exam_title][$class_title]['bukao'][]=$v2['student_fullname']['fullname'];
						//$arr_bukao[$exam_id][$v][]=$v2['student_fullname']['fullname'];
					}
					//echo $v2['classroom_title']['title'];
					//echo $v2['classroom_id'];
				}
			}
			//$arr_bukao=array();
        }
	//取差生结束
		//print_r($arr_rank);
        //exit; 
		$this->layout='//layouts/column1';
		$this->render('index',array(
			'fenyun'=>$arr_rank,
		));
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
		if($error=Yii::app()->errorHandler->error)
		{
			if(Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}
	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{
		$model=new ContactForm;
		if(isset($_POST['ContactForm']))
		{
			$model->attributes=$_POST['ContactForm'];
			if($model->validate())
			{
				$name='=?UTF-8?B?'.base64_encode($model->name).'?=';
				$subject='=?UTF-8?B?'.base64_encode($model->subject).'?=';
				$headers="From: $name <{$model->email}>\r\n".
					"Reply-To: {$model->email}\r\n".
					"MIME-Version: 1.0\r\n".
					"Content-type: text/plain; charset=UTF-8";

				mail(Yii::app()->params['adminEmail'],$subject,$model->body,$headers);
				Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact',array('model'=>$model));
	}

	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
		$model=new LoginForm;

		// if it is ajax validation request
		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}

		// collect user input data
		if(isset($_POST['LoginForm']))
		{
			$model->attributes=$_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login())
				$this->redirect(Yii::app()->user->returnUrl);
		}
		// display the login form
		$this->render('login',array('model'=>$model));
	}

	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout(false);
		$this->redirect(Yii::app()->homeUrl);
	}
	public function actionAbout()
	{	$this->layout='column1';
		$this->render('about');
	}
}