<?php

class TestcenterController extends Controller
{
	public $layout='//layouts/column2_';
	public $title='试题分类';
	public $menu;

	protected function beforeAction($action)
	{	
		$this->menu=array(
			array('label'=>'单选题中心', 'url'=>array('index','type'=>'single')),
			array('label'=>'多选题中心', 'url'=>array('index','type'=>'multi')),
			array('label'=>'判断题中心', 'url'=>array('index','type'=>'judge')),
			array('label'=>'操作题中心', 'url'=>array('index','type'=>'operate')),
		);
		
        $session=new CHttpSession;
		$session->open();
		$exam_id=$session['exam_id'];
		$student_id=Yii::app()->user->id;
		if(isset($exam_id)&&isset($student_id))
		{
			$data=Invigilator::model()->find(array(
				'condition'=>"exam_id=$exam_id and student_id=$student_id",
				'select'=>'submitmark',
			));
			if(!$data->submitmark)
			{
				Yii::app()->user->setFlash('shutoff','考试中，稍候访问！');
				$this->render('shutoff');return false;
				Yii::app()->end();
			}
						
		}
		return true;
	}	
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','create','update','delete'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}
	public function actionIndex($type=null)
	{
		if($type=='single')
		{
			$dataProvider=new CActiveDataProvider('Singlechoice');
		}
		if($type=='multi')
		{
			$dataProvider=new CActiveDataProvider('Multichoice');
			$this->render('index_multi',array(
			'dataProvider'=>$dataProvider,
			));
			Yii::app()->end();
		}
		if($type=='judge')
		{
			$dataProvider=new CActiveDataProvider('Judge');
			$this->render('index_judge',array(
			'dataProvider'=>$dataProvider,
			));
			Yii::app()->end();
		}
		if($type=='operate')
		{
			$dataProvider=new CActiveDataProvider('Operation');
			$this->render('index_operate',array(
			'dataProvider'=>$dataProvider,
			));
			Yii::app()->end();
		}
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}
	public function actionView($type,$id)
	{	$this->layout='//layouts/column1';
		if($type=='operate')
		{
			$this->render('view_operate',array(
				'model'=>Operation::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
		if($type=='judge')
		{
			$this->render('view_judge',array(
				'model'=>Judge::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
		if($type=='multi')
		{
			$this->render('view_multi',array(
				'model'=>Multichoice::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
		if($type=='single')
		{
			$this->render('view',array(
				'model'=>Singlechoice::model()->find("id='$id'"),
			));			
			Yii::app()->end();
		}
	}	
}