<?php

/**
 * This is the model class for table "{{errorset}}".
 *
 * The followings are the available columns in table '{{errorset}}':
 * @property integer $id
 * @property integer $student_id
 * @property string $singleError
 * @property string $multiError
 * @property string $judgeError
 * @property string $fillinError
 * @property string $faqError
 * @property string $operateError
 */
class Errorset extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Errorset the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{errorset}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_id, singleError, multiError, judgeError, fillinError, faqError, operateError', 'required'),
			array('student_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, student_id, singleError, multiError, judgeError, fillinError, faqError, operateError', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'student_id' => 'Student',
			'singleError' => 'Sigle Error',
			'multiError' => 'Multi Error',
			'judgeError' => 'Judge Error',
			'fillinError' => 'Fillin Error',
			'faqError' => 'Faq Error',
			'operateError' => 'Operate Error',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('student_id',$this->student_id);
		$criteria->compare('singleError',$this->singleError,true);
		$criteria->compare('multiError',$this->multiError,true);
		$criteria->compare('judgeError',$this->judgeError,true);
		$criteria->compare('fillinError',$this->fillinError,true);
		$criteria->compare('faqError',$this->faqError,true);
		$criteria->compare('operateError',$this->operateError,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}