<?php

/**
 * This is the model class for table "{{exammanage}}".
 *
 * The followings are the available columns in table '{{exammanage}}':
 * @property integer $id
 * @property string $title
 * @property string $singlechoicelist
 * @property string $multichoicelist
 * @property string $judgelist
 * @property string $fillinlist
 * @property string $faqlist
 * @property string $operatelist
 * @property string $testScore
 * @property string $testCount
 * @property string $testRand
 * @property string $summary
 * @property string $examState
 * @property string $examMode
 * @property integer $examTime
 * @property integer $beforeSubmit
 * @property string $created
 * @property string $modified
 * @property integer $testtype
 */
class Exammanage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Exammanage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{exammanage}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('examTime, beforeSubmit, testtype', 'numerical', 'integerOnly'=>true),
			array('title, singlechoicelist, multichoicelist, judgelist, fillinlist, faqlist, operatelist, testScore, testCount, testRand, summary, examState, examMode, created, modified', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, title, singlechoicelist, multichoicelist, judgelist, fillinlist, faqlist, operatelist, testScore, testCount, testRand, summary, examState, examMode, examTime, beforeSubmit, created, modified, testtype', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'singlechoicelist' => 'Singlechoicelist',
			'multichoicelist' => 'Multichoicelist',
			'judgelist' => 'Judgelist',
			'fillinlist' => 'Fillinlist',
			'faqlist' => 'Faqlist',
			'operatelist' => 'Operatelist',
			'testScore' => 'Test Score',
			'testCount' => 'Test Count',
			'testRand' => 'Test Rand',
			'summary' => 'Summary',
			'examState' => 'Exam State',
			'examMode' => 'Exam Mode',
			'examTime' => 'Exam Time',
			'beforeSubmit' => 'Before Submit',
			'created' => 'Created',
			'modified' => 'Modified',
			'testtype' => 'Testtype',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('singlechoicelist',$this->singlechoicelist,true);
		$criteria->compare('multichoicelist',$this->multichoicelist,true);
		$criteria->compare('judgelist',$this->judgelist,true);
		$criteria->compare('fillinlist',$this->fillinlist,true);
		$criteria->compare('faqlist',$this->faqlist,true);
		$criteria->compare('operatelist',$this->operatelist,true);
		$criteria->compare('testScore',$this->testScore,true);
		$criteria->compare('testCount',$this->testCount,true);
		$criteria->compare('testRand',$this->testRand,true);
		$criteria->compare('summary',$this->summary,true);
		$criteria->compare('examState',$this->examState,true);
		$criteria->compare('examMode',$this->examMode,true);
		$criteria->compare('examTime',$this->examTime);
		$criteria->compare('beforeSubmit',$this->beforeSubmit);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('testtype',$this->testtype);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}