<?php

/**
 * This is the model class for table "{{favorites}}".
 *
 * The followings are the available columns in table '{{favorites}}':
 * @property integer $id
 * @property integer $student_id
 * @property string $singleFavorites
 * @property string $multiFavorites
 * @property string $judgeFavorites
 * @property string $fillinFavorites
 * @property string $faqFavorites
 * @property string $operateFavorites
 */
class Favorites extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Favorites the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{favorites}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_id, singleFavorites, multiFavorites, judgeFavorites, fillinFavorites, faqFavorites, operateFavorites', 'required'),
			array('student_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, student_id, singleFavorites, multiFavorites, judgeFavorites, fillinFavorites, faqFavorites, operateFavorites', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'student_id' => 'Student',
			'singleFavorites' => 'Sigle Favorites',
			'multiFavorites' => 'Multi Favorites',
			'judgeFavorites' => 'Judge Favorites',
			'fillinFavorites' => 'Fillin Favorites',
			'faqFavorites' => 'Faq Favorites',
			'operateFavorites' => 'Operate Favorites',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('student_id',$this->student_id);
		$criteria->compare('singleFavorites',$this->singleFavorites,true);
		$criteria->compare('multiFavorites',$this->multiFavorites,true);
		$criteria->compare('judgeFavorites',$this->judgeFavorites,true);
		$criteria->compare('fillinFavorites',$this->fillinFavorites,true);
		$criteria->compare('faqFavorites',$this->faqFavorites,true);
		$criteria->compare('operateFavorites',$this->operateFavorites,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}