<?php

/**
 * This is the model class for table "{{invigilator}}".
 *
 * The followings are the available columns in table '{{invigilator}}':
 * @property integer $id
 * @property string $student_id
 * @property string $classroom_id
 * @property string $exam_id
 * @property string $starttime
 * @property string $submittime
 * @property integer $remaintime
 * @property integer $submitmark
 * @property integer $cheatmark
 */
class Invigilator extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Invigilator the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{invigilator}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_id, classroom_id, exam_id, remaintime, submitmark, cheatmark', 'required'),
			array('remaintime, submitmark, cheatmark', 'numerical', 'integerOnly'=>true),
			array('student_id, classroom_id, exam_id', 'length', 'max'=>11),
			array('starttime, submittime', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, student_id, classroom_id, exam_id, starttime, submittime, remaintime, submitmark, cheatmark', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'student_fullname' => array(self::BELONGS_TO, 'Student', 'student_id'),//一条考试记录属于一个考生
		'exammanage_examname' => array(self::BELONGS_TO, 'Exammanage', 'exam_id'),//一条考试记录属于一次考试
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'student_id' => 'Student',
			'classroom_id' => 'Classroom',
			'exam_id' => 'Exam',
			'starttime' => 'Starttime',
			'submittime' => 'Submittime',
			'remaintime' => '剩余时间',
			'submitmark' => 'Submitmark',
			'cheatmark' => 'Cheatmark',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('student_id',$this->student_id,true);
		$criteria->compare('classroom_id',$this->classroom_id,true);
		$criteria->compare('exam_id',$this->exam_id,true);
		$criteria->compare('starttime',$this->starttime,true);
		$criteria->compare('submittime',$this->submittime,true);
		$criteria->compare('remaintime',$this->remaintime);
		$criteria->compare('submitmark',$this->submitmark);
		$criteria->compare('cheatmark',$this->cheatmark);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	//不得不用扩展呀
	public function behaviors()
	{
		return array(
			'CArJSON'=>array(
				//'class'=>'ext.EJsonBehavior',
				//'class'=>'application.extensions.EJsonBehavior'
				'class'=>'ext.CArJSON',
		));
	}
}