<?php

/**
 * This is the model class for table "{{myexam}}".
 *
 * The followings are the available columns in table '{{myexam}}':
 * @property integer $id
 * @property integer $student_id
 * @property integer $exam_id
 * @property string $singlechoicelist
 * @property string $multichoicelist
 * @property string $judgelist
 * @property string $fillinlist
 * @property string $faqlist
 * @property string $operatelist
 * @property string $totalScore 
 */
class Myexam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Myexam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{myexam}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('student_id, exam_id, singlechoicelist, multichoicelist, judgelist, fillinlist, faqlist, operatelist,totalScore', 'required'),
			array('student_id, exam_id,totalScore', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, student_id, exam_id, singlechoicelist, multichoicelist, judgelist, fillinlist, faqlist, operatelist,totalScore', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'student_id' => 'Student',
			'exam_id' => 'Exam',
			'singlechoicelist' => 'Singlechoicelist',
			'multichoicelist' => 'Multichoicelist',
			'judgelist' => 'Judgelist',
			'fillinlist' => 'Fillinlist',
			'faqlist' => 'Faqlist',
			'operatelist' => 'Operatelist',
			'totalScore' => 'totalScore',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('student_id',$this->student_id);
		$criteria->compare('exam_id',$this->exam_id);
		$criteria->compare('singlechoicelist',$this->singlechoicelist,true);
		$criteria->compare('multichoicelist',$this->multichoicelist,true);
		$criteria->compare('judgelist',$this->judgelist,true);
		$criteria->compare('fillinlist',$this->fillinlist,true);
		$criteria->compare('faqlist',$this->faqlist,true);
		$criteria->compare('operatelist',$this->operatelist,true);
		$criteria->compare('totalScore',$this->totalScore,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}