<?php

/**
 * This is the model class for table "{{score}}".
 *
 * The followings are the available columns in table '{{score}}':
 * @property integer $id
 * @property integer $student_id
 * @property integer $classroom_id
 * @property integer $grade_id
 * @property integer $exam_id
 * @property integer $singlechoiceScore
 * @property integer $multichoiceScore
 * @property integer $judgeScore
 * @property integer $fillinScore
 * @property integer $faqScore
 * @property integer $operateScore
 * @property integer $totalScore
 * @property string $singlechoiceError
 * @property string $multichoiceError
 * @property string $judgeError
 * @property string $fillinAnswer
 * @property string $faqAnswer
 * @property string $operateAnswer
 * @property integer $reexam
 */
class Score extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Score the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{score}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('operateScore, totalScore', 'required'),
			//array('student_id, classroom_id, grade_id, exam_id, singlechoiceScore, multichoiceScore, judgeScore, fillinScore, faqScore, operateScore, totalScore, singlechoiceError, multichoiceError, judgeError, fillinAnswer, faqAnswer, operateAnswer', 'required'),
			array('student_id, classroom_id, grade_id, exam_id, singlechoiceScore, multichoiceScore, judgeScore, fillinScore, faqScore, operateScore, totalScore, reexam', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, student_id, classroom_id, grade_id, exam_id, singlechoiceScore, multichoiceScore, judgeScore, fillinScore, faqScore, operateScore, totalScore, singlechoiceError, multichoiceError, judgeError, fillinAnswer, faqAnswer, operateAnswer, reexam', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		'student_fullname' => array(self::BELONGS_TO, 'Student', 'student_id'),//一条成绩记录属于一个考生
		'classroom_title' => array(self::BELONGS_TO, 'Classroom', 'classroom_id'),//一条成绩记录属于一个班级
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'student_id' => '姓名',
			'classroom_id' => '班级',
			'grade_id' => '年级',
			'exam_id' => '考试id',
			'singlechoiceScore' => '单选分',
			'multichoiceScore' => '多选分',
			'judgeScore' => '判断分',
			'fillinScore' => 'Fillin Score',
			'faqScore' => 'Faq Score',
			'operateScore' => '操作题得分',
			'totalScore' => '总分',
			'singlechoiceError' => 'Singlechoice Error',
			'multichoiceError' => 'Multichoice Error',
			'judgeError' => 'Judge Error',
			'fillinAnswer' => 'Fillin Answer',
			'faqAnswer' => 'Faq Answer',
			'operateAnswer' => 'Operate Answer',
			'reexam' => '重考',
			'classroom_title.title' => '班级',
			'fullname' => '姓名',
		);
	}
	//取得班级列表
	public function getClassroomList($pid)
	{
		//return CHtml::listData(Classroom::model()->findAll("grade_id=$pid",array('order'=>'id ASC')),'id','title');
		$model = Classroom::model()->findAllByAttributes(array('grade_id'=>$pid));
		$data[]=array('id'=>'','title'=>'所有班级');
		$model=array_merge($data,$model);
		return CHtml::listData($model, 'id', 'title');
	}
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		//$criteria->compare('id',$this->id);
		//$criteria->compare('t.student_id',$this->student_id);
		$fullname=$this->student_id;
		/**/
		$arr=array();
		$data=Student::model()->findAll("fullname='$fullname'");
		
		if(!empty($data))
		{
			foreach($data as $k=>$v)
				{
					$arr[]=$v['id'];
				}
		$criteria->addInCondition('student_id',$arr);
		}else
		{
			$arr=array();
		}
		//addInCondition
		$criteria->compare('t.classroom_id',$this->classroom_id);
		$criteria->compare('t.grade_id',$this->grade_id);
		$criteria->compare('t.exam_id',$this->exam_id);
		$criteria->compare('singlechoiceScore',$this->singlechoiceScore);
		$criteria->compare('multichoiceScore',$this->multichoiceScore);
		$criteria->compare('judgeScore',$this->judgeScore);
		//$criteria->compare('fillinScore',$this->fillinScore);
		//$criteria->compare('faqScore',$this->faqScore);
		$criteria->compare('operateScore',$this->operateScore);
		$criteria->compare('totalScore',$this->totalScore);
		//$criteria->compare('singlechoiceError',$this->singlechoiceError,true);
		//$criteria->compare('multichoiceError',$this->multichoiceError,true);
		//$criteria->compare('judgeError',$this->judgeError,true);
		//$criteria->compare('fillinAnswer',$this->fillinAnswer,true);
		//$criteria->compare('faqAnswer',$this->faqAnswer,true);
		//$criteria->compare('operateAnswer',$this->operateAnswer,true);
		$criteria->compare('reexam',$this->reexam);
		/**/
		$criteria->together = true;
		//$criteria->compare( 'student_fullname.student_id', $this->student_id, true );
		$criteria->with=array('student_fullname','classroom_title');
		//$criteria->condition='t.student_id=student_fullname.id and t.classroom_id=classroom_title.id';
		
		//$criteria->sort =array('order' => 'totalScore');
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'pagination'=>array('pageSize'=>20),
			'sort'=>array(
            'defaultOrder'=>'totalScore DESC', //设置默认排序是create_time倒序
        ),
			
			)
			);
	}
	//不得不用扩展呀
	public function behaviors()
	{
		return array(
			'CArJSON'=>array(
				//'class'=>'ext.EJsonBehavior',
				//'class'=>'application.extensions.EJsonBehavior'
				'class'=>'ext.CArJSON',
		));
	}
}