<?php

/**
 * This is the model class for table "{{student}}".
 *
 * The followings are the available columns in table '{{student}}':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $salt
 * @property string $fullname
 * @property integer $sex
 * @property string $classroom_id
 * @property string $grade_id
 * @property string $photo
 * @property string $remark
 */
class Student extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Student the static model class
	 */
	public $verifyCode;
	public $confirmPassword;
	public $rememberMe;
	public $backend=0;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{student}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('username, fullname, sex, classroom_id, grade_id', 'required'),
			array('password,confirmPassword', 'required','on'=>'create'),
			array('username','unique','on'=>'create,update'),//,'className'=>'User'
			//array('password', 'compare', 'compareAttribute'=>'confirmPassword','on'=>'create,update'),
			array('confirmPassword', 'compare', 'compareAttribute'=>'password','on'=>'create,update'),
			//array('confirmPassword', 'compare', 'compareAttribute'=>'password','on'=>'update'),
			array('sex', 'numerical', 'integerOnly'=>true),
			array('username, password, fullname', 'length', 'max'=>16,'on'=>'create'),
			array('classroom_id, grade_id', 'length', 'max'=>8),
			array('photo','file','types'=>'jpg,gif,png','maxSize'=>'524288','allowEmpty'=>true),
			//array('photo','file','types'=>'jpg,gif,png','maxSize'=>'524288','allowEmpty'=>false,'on'=>'create'),//原版
			array('verifyCode', 'captcha', 'allowEmpty'=>!CCaptcha::checkRequirements()),
			array('remark', 'safe'),
			array('fullname', 'match','pattern'=>"/^[\x7f-\xff]+$/",'message'=>"姓名只能是中文！"),//这行也能用。还有说是080
			array('username,password', 'match','pattern'=>"/^[".chr(0xa1)."-".chr(0xff)."A-Za-z0-9_]+$/",'message'=>"只允许字母、数字、下划线！"),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, username, password, fullname, sex, classroom_id, grade_id', 'safe', 'on'=>'search'),
			//array('password,confirmPassword','alter_pwd','on'=>'update'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'nianji' => array(self::BELONGS_TO, 'Grade', 'grade_id'),//班级属于年级
			'banji' => array(self::BELONGS_TO, 'Classroom', 'classroom_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => '用户名',
			'password' => '密码',
			'salt' => 'Salt',
			'fullname' => '姓名',
			'sex' => '性别',
			'classroom_id' => '班级',
			'grade_id' => '年级',
			'photo' => '照片',
			'remark' => '自我介绍',
			'verifyCode'=>'验证码',
			'confirmPassword'=>'确认密码',
			'rememberMe'=>'记住我',
			'created'=>'创建日期',
			'modified'=>'修改日期',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('password',$this->password,true);
		$criteria->compare('salt',$this->salt,true);
		$criteria->compare('fullname',$this->fullname,true);
		$criteria->compare('sex',$this->sex);
		$criteria->compare('classroom_id',$this->classroom_id,true);
		$criteria->compare('grade_id',$this->grade_id,true);
		$criteria->compare('photo',$this->photo,true);
		$criteria->compare('remark',$this->remark,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	//取得年级列表
	public function getList()
	{
			return CHtml::listData(Grade::model()->findAll(array('order'=>'id ASC')),'id','title');
	}
	//取得班级列表
	public function getClassroomList($pid)
	{
		//return CHtml::listData(Classroom::model()->findAll("grade_id=$pid",array('order'=>'id ASC')),'id','title');
		$model = Classroom::model()->findAllByAttributes(array('grade_id'=>$pid));
		return CHtml::listData($model, 'id', 'title');
	}
	protected function generateSalt()//此函数用来产生一个时间的随机数，用于密码的加密。此函数在用户注册的时候有用。
	{
		return uniqid('',true);
	}
	//保存前要给密码加密。
	protected function beforeSave()
	{
		if(parent::beforeSave())
		{
			if($this->isNewRecord)
			{
				$salt=$this->generateSalt();
				$this->password=md5($salt.$this->password);
				$this->salt=$salt;
				$this->created=$this->modified=date("Y-m-d H:i:s",time()+8*3600);
				return true;
			}
			else
			{
				$this->modified=date("Y-m-d H:i:s",time()+8*3600);
				if($this->backend==1)
					return true;
				else
				{
					$salt=$this->generateSalt();
					if(isset($this->password))
					{
						$this->password=md5($salt.$this->password);
						$this->salt=$salt;
					}				
					return true;				
				}
			}
		}
		else
			return false;
	}
	//下面两个方法在组件中用到
	public function validatePassword($password)
	{
		return $this->hashPassword($password,$this->salt)===$this->password;
	}
	public function hashPassword($password,$salt)
	{
		return md5($salt.$password);
	}
	//未用
	protected function chinese()
	{
		if (preg_match("/^[\x7f-\xff]+$/", $str)) { //兼容gb2312,utf-8 
		echo "true";
		 } else {
		 echo "false";
		}
	}
	//取得年级-班级列表
	public function getGreadeClassroomList($table)
	{
		$data=Grade::model()->findAll();
		foreach($data as $key=>$value){$title=$value['title'];$id=$value['id'];
			echo '<li><span>';
			echo "<a href=\"javascript:addTab('$title','/admin/$table/list/grade_id/$id')\">";
			echo $value['title'];
			echo '</a>';
			echo '</span>';
			echo '<ul>';
			$data2=Classroom::model()->findAll("grade_id=:g_id",array(":g_id"=>$value['id']));
			foreach($data2 as $k=>$v)
			{$id=$v['id'];$title=$v['title'].'班';
				echo '<li><span>';
				echo "<a href=\"javascript:addTab('$title','/admin/$table/list/classroom_id/$id')\">";
				echo $v['title'].'班';
				echo '</a>';
				echo '</span></li>';
			}
			echo '</ul></li>';
		}
	}
	//取得年级-班级树
	public function getGreadeClassroomTree($table)
	{
		$data=Grade::model()->findAll();
		foreach($data as $key=>$value){
			echo '<li><span>'.$value['title'].'</span>';
			echo '<ul>';
			$data2=Classroom::model()->findAll("grade_id=:g_id",array(":g_id"=>$value['id']));
			foreach($data2 as $k=>$v)
			{$id=$v['id'];$title=$v['title'].'班';
				echo '<li><span>';
				echo "<a href=\"javascript:addTab('$title','/admin/$table/list/classroom_id/$id')\">";
				echo $v['title'].'班';
				echo '</a>';
				echo '</span></li>';
			}
			echo '</ul></li>';
		}
	}	
	//取得年级-班级树,只是加了班级，已弃用
	/*
	public function getGreadeClassroomTree2($table)
	{
		$data=Grade::model()->findAll();
		foreach($data as $key=>$value){
			echo '<li><span>'.$value['title'].'</span>';
			echo '<ul>';
			$data2=Classroom::model()->findAll("grade_id=:g_id",array(":g_id"=>$value['id']));$grade_id=$value['id'];
			foreach($data2 as $k=>$v)
			{$id=$v['id'];$title=$v['title'].'班';
				echo '<li><span>';
				echo "<a href=\"javascript:addTab('$title','/admin/$table/list/grade_id/$grade_id/classroom_id/$id')\">";
				echo $v['title'].'班';
				echo '</a>';
				echo '</span></li>';
			}
			echo '</ul></li>';
		}
	}
	*/
}