<?php

class AdminModule extends CWebModule
{
	public function init()
	{
		parent::init();
		// this method is called when the module is being created
		// you may place code here to customize the module or the application

		// import the module-level models and components
		$this->setImport(array(
			'application.models.*',
			'assistant.models.*',
			'admin.models.*',
			'admin.components.*',
		));
		//这里重写父类里的组件
		//如有需要还可以参考API添加相应组件
		Yii::app()->setComponents(array(
				'errorHandler'=>array(
						'class'=>'CErrorHandler',
						'errorAction'=>'admin/default/error',
				),
				'admin'=>array(
						'class'=>'AdminWebUser',
						'stateKeyPrefix'=>'admin',
						'allowAutoLogin'=>true,
						'loginUrl'=>Yii::app()->createUrl('admin/default/login'),
						'returnUrl' => Yii::app()->request->url,
				),
		), false);
		//$this->generatorPaths[]='admin.generators';
		//$this->controllerMap=$this->findGenerators();
	}

	public function beforeControllerAction($controller, $action)
	{
		if(parent::beforeControllerAction($controller, $action)){
			$route=$controller->id.'/'.$action->id;
			if(!$this->allowIp(Yii::app()->request->userHostAddress) && $route!=='default/error')
					throw new CHttpException(403,"You are not allowed to access this page.");
			$publicPages=array(
					'default/login',
					'default/error',
			);
			if(Yii::app()->admin->isGuest && !in_array($route,$publicPages))
					Yii::app()->admin->loginRequired();
			else
					return true;
		}
		return false;
	}
	protected function allowIp($ip)
	{
		if(empty($this->ipFilters))
				return true;
		foreach($this->ipFilters as $filter)
		{
				if($filter==='*' || $filter===$ip || (($pos=strpos($filter,'*'))!==false && !strncmp($ip,$filter,$pos)))
						return true;
		}
		return false;
	}	
	//开始1，详细说明未写
	/*
	private $_assetsUrl;  
	public function getAssetsUrl()  
	{  
		if($this->_assetsUrl===null)  
			$sourceFolder=YiiBase::getPathOfAlias('application.modules.admin.myfiles');
			//$sourceFolder=YiiBase::getPathOfAlias('application.modules.admin.assets');
			//Yii::app()->assetManager->basePath=YiiBase::getPathOfAlias('application.modules.admin.assets');
			//Yii::app()->assetManager->baseUrl=Yii::app()->baseUrl.'/protected/modules/admin/assets/';
			/*如果已经发布使用下面这行 
			$this->_assetsUrl=Yii::app()->assetManager->getPublishedUrl($sourceFolder);
			 *//*
			$this->_assetsUrl=Yii::app()->assetManager->publish($sourceFolder,false,-1,false);
		return $this->_assetsUrl;  
	}  

	public function setAssetsUrl($value)  
	{  
		$this->_assetsUrl=$value;  
	}
	*/
	//结束1
}
