<?php

class AssistantController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Assistant;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Assistant']))
		{
			$model->attributes=$_POST['Assistant'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Assistant']))
		{
			$model->attributes=$_POST['Assistant'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Assistant');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Assistant('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Assistant']))
			$model->attributes=$_GET['Assistant'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Assistant the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Assistant::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Assistant $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='assistant-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionList($classroom_id){
		$this->render('admin',array(
			'classroom_id'=>$classroom_id,
		));
	}
	//取所有数据
	public function actionQq($classroom_id){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$fullname=Yii::app()->request->getPost('fullname');//查询标题
		$condition_1="classroom_id='$classroom_id'";
		$condition_2="classroom_id='$classroom_id' and fullname like '%$fullname%'";
		$condition=(isset($fullname))?$condition_2:$condition_1;
		
		$model=new Assistant;
		$criteria=new CDbCriteria(array(
			'order'=>"$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'knowledgepoint.title,t.id,t.title',
			'condition'=>$condition,
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			//'with'=>'singletest',
		));

		$count = $model->count($criteria);
		$data3=$model->findAll($criteria);
		$data2=CJSON::encode($data3);
		$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
		echo $data;	
	}
	//>----------------更新或添加所有行
	public function actionAddandupdate(){
	$classroom_id=Yii::app()->request->getPost('classroom_id');
	//添加所有
	if(Yii::app()->request->getPost('action')=='addall')
	{
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
    //print_r($newarr);
    foreach($newarr as $value){
        $username=trim($value['username']);
		$password=md5(trim($value['password']));
		$fullname=trim($value['fullname']);
        $criteria=new CDbCriteria(array(
			'condition'=>"username='$username'",
		));
		$count = Assistant::model()->count($criteria);
        
        if($count>0){
            $str.='助手《'.$username.'》已经存在，请更换！<br/>';
        }else{
				$model=new Assistant;
				$Assistant['username']=$username;
				$Assistant['password']=$password;
				$Assistant['fullname']=$fullname;
				$Assistant['classroom_id']=$classroom_id;
                $model->attributes=$Assistant;
            if($model->save()){
                $str.='插入助手《'.$username.'》成功！<br/>';
            }else
            {
                $str.='插入助手《'.$username.'》失败！<br/>';
            }            
        }  
    }
	//更新所有
	}
	if(Yii::app()->request->getPost('action')=='updateall')
	{
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
    //print_r($newarr);
    foreach($newarr as $value){
        $username=trim($value['username']);
		$password=md5(trim($value['password']));
        $fullname=trim($value['fullname']);
		$id=trim($value['id']);
        $criteria=new CDbCriteria(array(
			'condition'=>"username='$username' and id!='$id'",
		));
		$count = Assistant::model()->count($criteria);
        
        if($count>0){
            $str.='助手《'.$username.'》已经存在，请更换！<br/>';
        }else{
				$model=$this->loadModel($id);
				$Assistant['username']=$username;
				$Assistant['password']=$password;
				$Assistant['fullname']=$fullname;
				$Assistant['classroom_id']=$classroom_id;
                $model->attributes=$Assistant;
            if($model->save()){
                $str.='更新助手《'.$username.'》成功！<br/>';
            }else
            {
                $str.='更新助手《'.$username.'》失败！<br/>';
            }            
        }  
    }
	}
	echo $str;	
	}
	//>---------------------单行删除
	public function actionDeleterow(){
		$id=Yii::app()->request->getPost('id');
		if($this->loadModel($id)->delete()){
			echo "yes";
		}
	}
	//>---------------多行删除
	public function actionDeleteall(){
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
		//print_r($newarr);
		foreach($newarr as $value){
			$username=trim($value['username']);
			$id=trim($value['id']);
		
				if($this->loadModel($id)->delete()){
					$str.='删除助手《'.$username.'》成功！<br/>';
				}else
				{
					$str.='删除助手《'.$username.'》失败！<br/>';
				}            
 
		}
		echo $str;
	}
}
