<?php

class ClassroomController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common';
	public $assetsUrl;
	public function init()
	{
		//$this->assetsUrl=$this->module->assetsUrl;
		//不再注册核心脚本，因为要生成两次Yii jquery 文件。
		//Yii::app()->getClientScript()->registerCoreScript('jquery');
	}
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','qq','gradelist','deleterow','addandupdate','deleteall'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Classroom;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Classroom']))
		{
			$model->attributes=$_POST['Classroom'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Classroom']))
		{
			$model->attributes=$_POST['Classroom'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Classroom');
		$data=Grade::model()->findAll();
		
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
			'gradelist'=>str_replace("id","grade",CJSON::encode($data)),
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Classroom('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Classroom']))
			$model->attributes=$_GET['Classroom'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Classroom::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='classroom-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	//获取班级列表
	public function actionQq(){
	    $criteria=new CDbCriteria(array(
			//'condition'=>"grade_id=2",
			'order'=>'t.id asc',
			'with'=>'nianji',
			'select'=>'grade.title,t.id,t.title',
		));
	$count = Classroom::model()->count($criteria);
	$model=Classroom::model()->findAll($criteria);
	$json = new CArJSON();
	// Define which relations do you want to load
	$relations = array('nianji');
	// Define which attributes, foreach relations do you want to load
	// root denote attributes for the main model
	$attributes = array(
		'root' => array('id', 'title'),
        'nianji' => array( 'title' ),
		//'votes' => null, // This will load all attributes
	);
	$data=$json->toJSON($model, $relations, $attributes);
	//print_r(CJSON::decode($data));
	$i=0;
	foreach(CJSON::decode($data) as $key=>$value)
	{
		//echo $key;echo $value['attributes']['id'];
		$newarr[$i]['id']=$value['attributes']['id'];
		$newarr[$i]['title']=$value['attributes']['title'];
		$newarr[$i]['grade']=$value['relations']['nianji']['title'];$i++;
	}
	//echo CJSON::encode($newarr);
	
		
		//$data=Classroom::model()->with('nianji')->findAll($criteria);
		//echo $data;
	//echo CJSON::encode($data);
	
		//$arr=array(array('id'=>1,'title'=>'高一'),array('id'=>1,'title'=>'高三'));
		$data2=CJSON::encode($newarr);
		$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
		echo $data;
	}
	//获取班级列表
	public function actionGradelist(){
		$data=Grade::model()->findAll();
		//echo str_replace("id","grade",CJSON::encode($data));
		//echo CJSON::encode($data);
		echo '[{"grade":"1","title":"高一"},{"grade":"2","title":"高二"},{"grade":"3","title":"高三"}]';
	}
	//>----------------更新或添加所有行
	public function actionAddandupdate(){
	//添加所有
	if(Yii::app()->request->getPost('action')=='addall')
	{
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
    //print_r($newarr);
    foreach($newarr as $value){
        $title=trim($value['title']);
		$grade_id=trim($value['grade']);
		
        $criteria=new CDbCriteria(array(
			'condition'=>"title='$title'",
		));
		$count = Classroom::model()->count($criteria);
        
        if($count>0){
            $str.='班级《'.$title.'》已经存在，请更换！<br/>';
        }else{
				$model=new Classroom;
				$Classroom['title']=$title;
				if(is_numeric($grade_id)){$Classroom['grade_id']=$grade_id;}
                $model->attributes=$Classroom;
            if($model->save()){
                $str.='插入班级《'.$title.'》成功！<br/>';
            }else
            {
                $str.='插入班级《'.$title.'》失败！<br/>';
            }            
        }  
    }
	//更新所有
	}
	if(Yii::app()->request->getPost('action')=='updateall')
	{
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
    //print_r($newarr);
    foreach($newarr as $value){
        $title=trim($value['title']);
		$grade_id=trim($value['grade']);
		$id=trim($value['id']);
        $criteria=new CDbCriteria(array(
			'condition'=>"title='$title' and id!='$id'",
		));
		$count = Classroom::model()->count($criteria);
        
        if($count>0){
            $str.='班级《'.$title.'》已经存在，请更换！<br/>';
        }else{
				$model=$this->loadModel($id);
				$Classroom['title']=$title;
				if(is_numeric($grade_id)){$Classroom['grade_id']=$grade_id;}
                $model->attributes=$Classroom;
            if($model->save()){
                $str.='更新班级《'.$title.'》成功！<br/>';
            }else
            {
                $str.='更新班级《'.$title.'》失败！<br/>';
            }            
        }  
    }
	}
	echo $str;	
	}
	//>---------------------单行删除
	public function actionDeleterow(){
		$id=Yii::app()->request->getPost('id');
		if($this->loadModel($id)->delete()){
			echo "yes";
		}
	}
	//>---------------多行删除
	public function actionDeleteall(){
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
		//print_r($newarr);
		foreach($newarr as $value){
			$title=trim($value['title']);
			$id=trim($value['id']);
		
				if($this->loadModel($id)->delete()){
					$str.='删除知识点《'.$title.'》成功！<br/>';
				}else
				{
					$str.='删除知识点《'.$title.'》失败！<br/>';
				}            
 
		}
		echo $str;
	}
}
