<?php

class ExammanageController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common2';
	public $assetsUrl;
	public function init()
	{
		//$this->assetsUrl=$this->module->assetsUrl;
		//不再注册核心脚本，因为要生成两次Yii jquery 文件。
		//Yii::app()->getClientScript()->registerCoreScript('jquery');
	}
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Exammanage;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Exammanage']))
		{
			$data=Tempdata::model()->findByPk(1);
			$model->attributes=$_POST['Exammanage'];
			$model->singlechoicelist=$data->single_id;
			$model->multichoicelist=$data->multi_id;
			$model->judgelist=$data->judge_id;
			$model->operatelist=$data->operate_id;
			$model->testtype=1;
			//更新试题使用频率
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$data->single_id));
			Singlechoice::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$data->multi_id));
			Multichoice::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$data->judge_id));
			Judge::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$data->operate_id));
			Operation::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			if($model->save()){
				$data=Tempdata::model()->findByPk(1);
				$data->attributes=array('operate_id'=>'','judge_id'=>'','multi_id'=>'','single_id'=>'');
				$data->update();

				header('Content-Type: text/html; charset=utf-8');
				echo "<script>alert('添加成功！请继续添加！');history.back(-1)</script>";
				}
		}
		$data=Tempdata::model()->findByPk(1);
		$data->attributes=array('operate_id'=>'','judge_id'=>'','multi_id'=>'','single_id'=>'');
		$data->update();

		$this->render('create',array(
			'model'=>$model,
		));
	}
	public function actionCreate2()
	{
		$model=new Exammanage;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Exammanage']))
		{	
			$model->attributes=$_POST['Exammanage'];
			$model->testtype=2;
			$single_count=$_POST['Exammanage']['singlechoicelist'];
			$multi_count=$_POST['Exammanage']['multichoicelist'];
			$judge_count=$_POST['Exammanage']['judgelist'];
			$operate_count=$_POST['Exammanage']['operatelist'];
			
			$single_range=$_POST['Exammanage']['singlechoicelist_range'];
			$multi_range=$_POST['Exammanage']['multichoicelist_range'];
			$judge_range=$_POST['Exammanage']['judgelist_range'];
			$operate_range=$_POST['Exammanage']['operatelist_range'];
			$single_id=$multi_id=$judge_id=$operate_id='';
			//单选列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$single_range));
			$data_danxuan=Singlechoice::model()->findAll($criteria);
			shuffle($data_danxuan);
			$data_danxuan = array_slice($data_danxuan,0,$single_count);
			foreach($data_danxuan as $k=>$v)
			{
				empty($single_id)?$single_id=$v['id']:$single_id.=','.$v['id'];
			}
			$model->singlechoicelist=$single_id;

			//多选列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$multi_range));
			$data_duoxuan=Multichoice::model()->findAll($criteria);
			shuffle($data_duoxuan);
			$data_duoxuan = array_slice($data_duoxuan,0,$multi_count);
			foreach($data_duoxuan as $k=>$v)
			{
				empty($multi_id)?$multi_id=$v['id']:$multi_id.=','.$v['id'];
			}			
			$model->multichoicelist=$multi_id;

			//判断列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$judge_range));
			$data_panduan=Judge::model()->findAll($criteria);
			shuffle($data_panduan);
			$data_panduan = array_slice($data_panduan,0,$judge_count);
			foreach($data_panduan as $k=>$v)
			{
				empty($judge_id)?$judge_id=$v['id']:$judge_id.=','.$v['id'];
			}			
			$model->judgelist=$judge_id;

			//操作列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$operate_range));
			$data_caozuo=Operation::model()->findAll($criteria);
			shuffle($data_caozuo);
			$data_caozuo = array_slice($data_caozuo,0,$operate_count);
			foreach($data_caozuo as $k=>$v)
			{
				empty($operate_id)?$operate_id=$v['id']:$operate_id.=','.$v['id'];
			}			
			$model->operatelist=$operate_id;



			//更新试题使用频率
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$single_id));
			Singlechoice::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$multi_id));
			Multichoice::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$judge_id));
			Judge::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			
			$criteria=new CDbCriteria;
			$criteria->addInCondition('id',explode(',',$operate_id));
			Operation::model()->updateCounters(array('frequency'=>1),$criteria);//自动+1
			if($model->save()){
				header('Content-Type: text/html; charset=utf-8');
				echo "<script>alert('添加成功！请继续添加！');history.back(-1)</script>";
				}
		}

		$this->render('create2',array(
			'model'=>$model,
		));
	}
	public function actionCreate3()
	{
		$model=new Exammanage;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Exammanage']))
		{	
			$model->attributes=$_POST['Exammanage'];
			$model->testtype=3;
			if($model->save()){
				header('Content-Type: text/html; charset=utf-8');
				echo "<script>alert('添加成功！请继续添加！');history.back(-1)</script>";
				}
		}

		$this->render('create3',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{   $model=$this->loadModel($id);
		if(isset($_POST['Exammanage']))
		{
			$data=Tempdata::model()->findByPk(1);
			$model->attributes=$_POST['Exammanage'];
			$model->singlechoicelist=$data->single_id;
			$model->multichoicelist=$data->multi_id;
			$model->judgelist=$data->judge_id;
			$model->operatelist=$data->operate_id;
			$model->testtype=1;
			if($model->save()){
				$data=Tempdata::model()->findByPk(1);
				$data->attributes=array('operate_id'=>'','judge_id'=>'','multi_id'=>'','single_id'=>'');
				$data->update();

				header('Content-Type: text/html; charset=utf-8');
				echo "<script>alert('修改成功！请关闭此窗口！');history.back(-1)</script>";}
				exit;
		}
		
		$data=Tempdata::model()->findByPk(1);
		$data->single_id=$model->singlechoicelist;
		$data->multi_id=$model->multichoicelist;
		$data->judge_id=$model->judgelist;
		$data->operate_id=$model->operatelist;
		$data->save(false);
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);


		$this->render('update',array(
			'model'=>$model,
		));
	}
	public function actionUpdate2($id)
	{   $model=$this->loadModel($id);
		if(isset($_POST['Exammanage']))
		{
			$model->attributes=$_POST['Exammanage'];
			$model->testtype=2;
			$single_count=$_POST['Exammanage']['singlechoicelist'];
			$multi_count=$_POST['Exammanage']['multichoicelist'];
			$judge_count=$_POST['Exammanage']['judgelist'];
			$operate_count=$_POST['Exammanage']['operatelist'];
			
			$single_range=$_POST['Exammanage']['singlechoicelist_range'];
			$multi_range=$_POST['Exammanage']['multichoicelist_range'];
			$judge_range=$_POST['Exammanage']['judgelist_range'];
			$operate_range=$_POST['Exammanage']['operatelist_range'];
			$single_id=$multi_id=$judge_id=$operate_id='';
			//单选列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$single_range));
			$data_danxuan=Singlechoice::model()->findAll($criteria);
			shuffle($data_danxuan);
			$data_danxuan = array_slice($data_danxuan,0,$single_count);
			foreach($data_danxuan as $k=>$v)
			{
				empty($single_id)?$single_id=$v['id']:$single_id.=','.$v['id'];
			}
			$model->singlechoicelist=$single_id;

			//多选列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$multi_range));
			$data_duoxuan=Multichoice::model()->findAll($criteria);
			shuffle($data_duoxuan);
			$data_duoxuan = array_slice($data_duoxuan,0,$multi_count);
			foreach($data_duoxuan as $k=>$v)
			{
				empty($multi_id)?$multi_id=$v['id']:$multi_id.=','.$v['id'];
			}			
			$model->multichoicelist=$multi_id;

			//判断列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$judge_range));
			$data_panduan=Judge::model()->findAll($criteria);
			shuffle($data_panduan);
			$data_panduan = array_slice($data_panduan,0,$judge_count);
			foreach($data_panduan as $k=>$v)
			{
				empty($judge_id)?$judge_id=$v['id']:$judge_id.=','.$v['id'];
			}			
			$model->judgelist=$judge_id;

			//操作列表
			$criteria=new CDbCriteria(array(
			'select'=>array('id'),
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			));
			$criteria->addInCondition('charpter_id',explode(',',$operate_range));
			$data_caozuo=Operation::model()->findAll($criteria);
			shuffle($data_caozuo);
			$data_caozuo = array_slice($data_caozuo,0,$operate_count);
			foreach($data_caozuo as $k=>$v)
			{
				empty($operate_id)?$operate_id=$v['id']:$operate_id.=','.$v['id'];
			}			
			$model->operatelist=$operate_id;
			if($model->save()){
				header('Content-Type: text/html; charset=utf-8');
				echo "<script>alert('修改成功！请关闭此窗口！');history.back(-1)</script>";}
				exit;
		}
		$this->render('update2',array(
			'model'=>$model,
		));
	}
	public function actionUpdate3($id)
	{   $model=$this->loadModel($id);
		if(isset($_POST['Exammanage']))
		{
			$model->attributes=$_POST['Exammanage'];
			$model->testtype=3;
			if($model->save()){
				header('Content-Type: text/html; charset=utf-8');
				echo "<script>alert('修改成功！请关闭此窗口！');history.back(-1)</script>";}
				exit;
		}
		$this->render('update3',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Exammanage');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Exammanage('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Exammanage']))
			$model->attributes=$_GET['Exammanage'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Exammanage::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='exammanage-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionList($charpter_id){
		$this->render('admin',array(
			'charpter_id'=>$charpter_id,
		));
	}
	//取所有数据---------------->单选题
	public function actionQq(){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$str=Yii::app()->request->getPost('charpter_id');
		$arr_in=explode(",",$str);
		$data=Tempdata::model()->findByPk(1);
		$str_not_in=$data->single_id;
		$arr_not_in=explode(",",$str_not_in);

		//$criteria = new CDbCriteria;
		
	
		//$title=Yii::app()->request->getPost('title');//查询标题
		//$condition_1="charpter_id='$charpter_id'";
		//$condition_2="charpter_id='$charpter_id' and t.title='$title'";
		//$condition=(isset($title))?$condition_2:$condition_1;
		
		$model=new Singlechoice;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			'condition'=>"forbidden = 0",
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			'with'=>'singlecharpter',
		));
		$criteria->addInCondition('t.charpter_id',$arr_in);
		$criteria->addNotInCondition('t.id',$arr_not_in);

		$count = $model->count($criteria);
		$data3=$model->findAll($criteria);
		
		$json = new CArJSON();
		// Define which relations do you want to load
		$relations = array('singlecharpter');
		// Define which attributes, foreach relations do you want to load
		// root denote attributes for the main model
		$attributes = array(
			'root' => array('id', 'title','created','modified','frequency','difficulty','forbidden'),//表示主表中的字段
			'singlecharpter' => array( 'title' ),//表示从表中的字段
			//'votes' => null, // This will load all attributes
		);
		$data=$json->toJSON($data3, $relations, $attributes);
		//print_r(CJSON::decode($data));
		$i=0;$newarr=array();
		foreach(CJSON::decode($data) as $key=>$value)
		{
			//echo $key;echo $value['attributes']['id'];
			$newarr[$i]['id']=$value['attributes']['id'];
			$newarr[$i]['title']=$value['attributes']['title'];
			$newarr[$i]['created']=$value['attributes']['created'];
			$newarr[$i]['modified']=$value['attributes']['modified'];
			$newarr[$i]['frequency']=$value['attributes']['frequency'];
			$newarr[$i]['forbidden']=($value['attributes']['forbidden'])?'是':'否';
			$newarr[$i]['difficulty']=$value['attributes']['difficulty'];
			$newarr[$i]['charpter_id']=$value['relations']['singlecharpter']['title'];$i++;
		}

			$data2=CJSON::encode($newarr);
			$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
			echo $data;
		
	}
	//取所有数据---------------->多选题
	public function actionQq2(){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$str=Yii::app()->request->getPost('charpter_id');
		$arr_in=explode(",",$str);
		$data=Tempdata::model()->findByPk(1);
		$str_not_in=$data->multi_id;
		$arr_not_in=explode(",",$str_not_in);

		//$criteria = new CDbCriteria;
		
	
		//$title=Yii::app()->request->getPost('title');//查询标题
		//$condition_1="charpter_id='$charpter_id'";
		//$condition_2="charpter_id='$charpter_id' and t.title='$title'";
		//$condition=(isset($title))?$condition_2:$condition_1;
		
		$model=new Multichoice;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			'condition'=>"forbidden = 0",
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			'with'=>'multicharpter',
		));
		$criteria->addInCondition('t.charpter_id',$arr_in);
		$criteria->addNotInCondition('t.id',$arr_not_in);

		$count = $model->count($criteria);
		$data3=$model->findAll($criteria);
		
		$json = new CArJSON();
		// Define which relations do you want to load
		$relations = array('multicharpter');
		// Define which attributes, foreach relations do you want to load
		// root denote attributes for the main model
		$attributes = array(
			'root' => array('id', 'title','created','modified','frequency','difficulty','forbidden'),//表示主表中的字段
			'multicharpter' => array( 'title' ),//表示从表中的字段
			//'votes' => null, // This will load all attributes
		);
		$data=$json->toJSON($data3, $relations, $attributes);
		//print_r(CJSON::decode($data));
		$i=0;$newarr=array();
		foreach(CJSON::decode($data) as $key=>$value)
		{
			//echo $key;echo $value['attributes']['id'];
			$newarr[$i]['id']=$value['attributes']['id'];
			$newarr[$i]['title']=$value['attributes']['title'];
			$newarr[$i]['created']=$value['attributes']['created'];
			$newarr[$i]['modified']=$value['attributes']['modified'];
			$newarr[$i]['frequency']=$value['attributes']['frequency'];
			$newarr[$i]['forbidden']=($value['attributes']['forbidden'])?'是':'否';
			$newarr[$i]['difficulty']=$value['attributes']['difficulty'];
			$newarr[$i]['charpter_id']=$value['relations']['multicharpter']['title'];$i++;
		}

			$data2=CJSON::encode($newarr);
			$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
			echo $data;
		
	}
	//取所有数据---------------->判断题
	public function actionQq3(){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$str=Yii::app()->request->getPost('charpter_id');
		$arr_in=explode(",",$str);
		$data=Tempdata::model()->findByPk(1);
		$str_not_in=$data->judge_id;
		$arr_not_in=explode(",",$str_not_in);

		//$criteria = new CDbCriteria;
		
	
		//$title=Yii::app()->request->getPost('title');//查询标题
		//$condition_1="charpter_id='$charpter_id'";
		//$condition_2="charpter_id='$charpter_id' and t.title='$title'";
		//$condition=(isset($title))?$condition_2:$condition_1;
		
		$model=new Judge;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			'condition'=>"forbidden = 0",
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			'with'=>'judgecharpter',
		));
		$criteria->addInCondition('t.charpter_id',$arr_in);
		$criteria->addNotInCondition('t.id',$arr_not_in);

		$count = $model->count($criteria);
		$data3=$model->findAll($criteria);
		
		$json = new CArJSON();
		// Define which relations do you want to load
		$relations = array('judgecharpter');
		// Define which attributes, foreach relations do you want to load
		// root denote attributes for the main model
		$attributes = array(
			'root' => array('id', 'title','created','modified','frequency','difficulty','forbidden'),//表示主表中的字段
			'judgecharpter' => array( 'title' ),//表示从表中的字段
			//'votes' => null, // This will load all attributes
		);
		$data=$json->toJSON($data3, $relations, $attributes);
		//print_r(CJSON::decode($data));
		$i=0;$newarr=array();
		foreach(CJSON::decode($data) as $key=>$value)
		{
			//echo $key;echo $value['attributes']['id'];
			$newarr[$i]['id']=$value['attributes']['id'];
			$newarr[$i]['title']=$value['attributes']['title'];
			$newarr[$i]['created']=$value['attributes']['created'];
			$newarr[$i]['modified']=$value['attributes']['modified'];
			$newarr[$i]['frequency']=$value['attributes']['frequency'];
			$newarr[$i]['forbidden']=($value['attributes']['forbidden'])?'是':'否';
			$newarr[$i]['difficulty']=$value['attributes']['difficulty'];
			$newarr[$i]['charpter_id']=$value['relations']['judgecharpter']['title'];$i++;
		}

			$data2=CJSON::encode($newarr);
			$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
			echo $data;
		
	}
	//取所有数据---------------->操作题
	public function actionQq4(){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$str=Yii::app()->request->getPost('charpter_id');
		$arr_in=explode(",",$str);
		$data=Tempdata::model()->findByPk(1);
		$str_not_in=$data->operate_id;
		$arr_not_in=explode(",",$str_not_in);

		//$criteria = new CDbCriteria;
		
	
		//$title=Yii::app()->request->getPost('title');//查询标题
		//$condition_1="charpter_id='$charpter_id'";
		//$condition_2="charpter_id='$charpter_id' and t.title='$title'";
		//$condition=(isset($title))?$condition_2:$condition_1;
		
		$model=new Operation;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'category.title,t.id,t.title,t.created,t.modified,t.frequency,t.difficulty,t.forbidden',
			'condition'=>"forbidden = 0",
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			'with'=>'operationcharpter',
		));
		$criteria->addInCondition('t.charpter_id',$arr_in);
		$criteria->addNotInCondition('t.id',$arr_not_in);

		$count = $model->count($criteria);
		$data3=$model->findAll($criteria);
		
		$json = new CArJSON();
		// Define which relations do you want to load
		$relations = array('operationcharpter');
		// Define which attributes, foreach relations do you want to load
		// root denote attributes for the main model
		$attributes = array(
			'root' => array('id', 'title','created','modified','frequency','difficulty','forbidden'),//表示主表中的字段
			'operationcharpter' => array( 'title' ),//表示从表中的字段
			//'votes' => null, // This will load all attributes
		);
		$data=$json->toJSON($data3, $relations, $attributes);
		//print_r(CJSON::decode($data));
		$i=0;$newarr=array();
		foreach(CJSON::decode($data) as $key=>$value)
		{
			//echo $key;echo $value['attributes']['id'];
			$newarr[$i]['id']=$value['attributes']['id'];
			$newarr[$i]['title']=$value['attributes']['title'];
			$newarr[$i]['created']=$value['attributes']['created'];
			$newarr[$i]['modified']=$value['attributes']['modified'];
			$newarr[$i]['frequency']=$value['attributes']['frequency'];
			$newarr[$i]['forbidden']=($value['attributes']['forbidden'])?'是':'否';
			$newarr[$i]['difficulty']=$value['attributes']['difficulty'];
			$newarr[$i]['charpter_id']=$value['relations']['operationcharpter']['title'];$i++;
		}

			$data2=CJSON::encode($newarr);
			$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
			echo $data;
		
	}
	//取所有数据---------------->考试列表
	public function actionExamlist(){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$title=Yii::app()->request->getPost('title');//查询标题
		$condition_1="";
		$condition_2="t.title='$title'";
		$condition=(isset($title))?$condition_2:$condition_1;
		
		$model=new Exammanage;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'knowledgepoint.title,t.id,t.title',
			'condition'=>$condition,
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
		));

		$count = $model->count($criteria);
		$data3=$model->findAll($criteria);
		foreach($data3 as $k=>$v){
			($v['examState'])?$data3[$k]['examState']='Yes':$data3[$k]['examState']='No';
			($v['examMode'])?$data3[$k]['examMode']='Yes':$data3[$k]['examMode']='No';
			switch($v['testtype'])
			{
				case 1:
				$data3[$k]['testtype']='阶段考试';
				break;
				case 2:
				$data3[$k]['testtype']='综合考试';
				break;
				case 3:
				$data3[$k]['testtype']='仿真考试';
				break;
			}
			//if($v['examState']){$data3[$k]['examState']='是';}else {$data3[$k]['examState']='否';}
		}
		$data2=CJSON::encode($data3);
		$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
		echo $data;			
	}
	//>---------------选择试题
	public function actionSelectall(){
		$model=Tempdata::model()->findByPk(1);
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		//print_r($arr);exit;
		if(Yii::app()->request->getPost('action')=='selectsingle'){
			if(empty($model->single_id)){$str=implode(',',$arr);}else{$str=$model->single_id.','.implode(',',$arr);}
			$model->attributes=array('single_id'=>$str);
			if($model->update()){
				echo "选择成功！请继续选择！";
			}		
		}
		if(Yii::app()->request->getPost('action')=='selectmulti'){
			if(empty($model->multi_id)){$str=implode(',',$arr);}else{$str=$model->multi_id.','.implode(',',$arr);}
			$model->attributes=array('multi_id'=>$str);
			if($model->update()){
				echo "选择成功！请继续选择！";
			}		
		}
		if(Yii::app()->request->getPost('action')=='selectjudge'){
			if(empty($model->judge_id)){$str=implode(',',$arr);}else{$str=$model->judge_id.','.implode(',',$arr);}
			$model->attributes=array('judge_id'=>$str);
			if($model->update()){
				echo "选择成功！请继续选择！";
			}		
		}
		if(Yii::app()->request->getPost('action')=='selectoperate'){
			if(empty($model->operate_id)){$str=implode(',',$arr);}else{$str=$model->operate_id.','.implode(',',$arr);}
			$model->attributes=array('operate_id'=>$str);
			if($model->update()){
				echo "选择成功！请继续选择！";
			}		
		}
	}
	//>--------------------重新选择
	public function actionResetall(){
		$model=Tempdata::model()->findByPk(1);
		if(Yii::app()->request->getPost('action')=='resetsingle'){
			$model->attributes=array('single_id'=>'');
			if($model->update()){
				echo "已清空，请重新选择！";
			}
			exit;
		}
		if(Yii::app()->request->getPost('action')=='resetmulti'){
			$model->attributes=array('multi_id'=>'');
			if($model->update()){
				echo "已清空，请重新选择！";
			}
			exit;
		}
		if(Yii::app()->request->getPost('action')=='resetjudge'){
			$model->attributes=array('judge_id'=>'');
			if($model->update()){
				echo "已清空，请重新选择！";
			}
			exit;
		}
		if(Yii::app()->request->getPost('action')=='resetoperate'){
			$model->attributes=array('operate_id'=>'');
			if($model->update()){
				echo "已清空，请重新选择！";
			}
			exit;
		}
	}
	//>---------------------单行删除
	public function actionDeleterow(){
		$id=Yii::app()->request->getPost('id');
		if($this->loadModel($id)->delete()){
			echo "yes";
		}
	}
	//>---------------多行删除
	public function actionDeleteall(){
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
		//print_r($newarr);
		foreach($newarr as $value){
			$title=trim($value['title']);
			$id=trim($value['id']);
				if($this->loadModel($id)->delete()){
					$str.='删除考试《'.$title.'》成功！<br/>';
				}else
				{
					$str.='删除考试《'.$title.'》失败！<br/>';
				}            
		}
		echo $str;
	}
	//->------------------禁用或启用
	public function actionOnoff($charpter_id=null){
		$model=new Exammanage;
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		$onoff=Yii::app()->request->getPost('action');
		//print_r($arr);exit;
		if(!empty($arr)){
			foreach($arr as $value){
				$arr_in[]=$value['id'];
			}
		$criteria = new CDbCriteria;
		$criteria->addInCondition('id',$arr_in);			
		}
		//print_r($newarr);exit;
		//$criteria2=new CDbCriteria(array(
			//'condition'=>"charpter_id='$charpter_id'",
		//));
		if($onoff=="addon"){
			$data=$model->updateAll(array('examState'=>false),$criteria);
			if($data) echo "启用成功！";else echo "启用失败！";
		}
		if($onoff=="addoff"){
			$data=$model->updateAll(array('examState'=>true),$criteria);
			if($data) echo "禁用成功！";else echo "禁用失败！";
		}
		if($onoff=="alladdon"){
			$data=$model->updateAll(array('examState'=>false));
			if($data) echo "全体启用成功！";else echo "全体启用失败！";
		}
		if($onoff=="alladdoff"){
			$data=$model->updateAll(array('examState'=>true));
			if($data) echo "全体禁用成功！";else echo "全体禁用失败！";
		}
	}
	//取所有数据---------------->随机取题单选、多选、判断和操作都有
	public function actionRandqq(){
		$type=Yii::app()->request->getPost('action');
		$str=Yii::app()->request->getPost('qq');
		$arr_in=explode(",",$str);
		if($type=='single')
		{
			$model=new Singlechoice;
			$criteria=new CDbCriteria(array(
				//'order'=>"t.$sort $order",
				'select'=>array('id'),//'id,title',
				'condition'=>"forbidden = 0",
			));
			$criteria->addInCondition('t.charpter_id',$arr_in);

			$count = $model->count($criteria);
			echo $count;		
		}
		if($type=='multi')
		{
			$model=new Multichoice;
			$criteria=new CDbCriteria(array(
				//'order'=>"t.$sort $order",
				'select'=>array('id'),//'id,title',
				'condition'=>"forbidden = 0",
			));
			$criteria->addInCondition('t.charpter_id',$arr_in);

			$count = $model->count($criteria);
			echo $count;		
		}
		if($type=='judge')
		{
			$model=new Judge;
			$criteria=new CDbCriteria(array(
				//'order'=>"t.$sort $order",
				'select'=>array('id'),//'id,title',
				'condition'=>"forbidden = 0",
			));
			$criteria->addInCondition('t.charpter_id',$arr_in);

			$count = $model->count($criteria);
			echo $count;		
		}
		if($type=='operate')
		{
			$model=new Operation;
			$criteria=new CDbCriteria(array(
				//'order'=>"t.$sort $order",
				'select'=>array('id'),//'id,title',
				'condition'=>"forbidden = 0",
			));
			$criteria->addInCondition('t.charpter_id',$arr_in);

			$count = $model->count($criteria);
			echo $count;		
		}		
	}
}
