<?php

class KnowledgelistController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common';
	public $assetsUrl;
	public function init()
	{
		//$this->assetsUrl=$this->module->assetsUrl;
		//不再注册核心脚本，因为要生成两次Yii jquery 文件。
		//Yii::app()->getClientScript()->registerCoreScript('jquery');
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Knowledgelist;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Knowledgelist']))
		{
			$model->attributes=$_POST['Knowledgelist'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Knowledgelist']))
		{
			$model->attributes=$_POST['Knowledgelist'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Knowledgelist');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Knowledgelist('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Knowledgelist']))
			$model->attributes=$_GET['Knowledgelist'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Knowledgelist::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='knowledgelist-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionQq(){
	    $criteria=new CDbCriteria(array(
			'order'=>'id asc',
		));
		$count = Knowledgelist::model()->count($criteria);
		$model=Knowledgelist::model()->findAll($criteria);
		//$arr=array(array('id'=>1,'title'=>'高一'),array('id'=>1,'title'=>'高三'));
		$data2=CJSON::encode($model);
		$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
		echo $data;
	}
	//单行删除
	public function actionDeleterow(){
		$id=Yii::app()->request->getPost('id');
		$criteria=new CDbCriteria(array(
			'condition'=>"Knowledgelist_id='$id'",
		));
		$count=Knowledgepoint::model()->count($criteria);
		if($count>0) {echo "该知识点分类下仍有知识点，请先删除对应的知识点！";exit;}
		if($this->loadModel($id)->delete()){
			echo "yes";
		}
	}
	//多行删除
	public function actionDeleteall(){
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
		//print_r($newarr);
		foreach($newarr as $value){
			$title=trim($value['title']);
			$id=trim($value['id']);
			$criteria=new CDbCriteria(array(
				'condition'=>"Knowledgelist_id='$id'",
			));
			$count=Knowledgepoint::model()->count($criteria);
		
			if($count>0){
				$str.='知识点分类《'.$title.'》仍有知识点，请先删除对应的知识点！<br/>';
			}else{
				if($this->loadModel($id)->delete()){
					$str.='删除知识点分类《'.$title.'》成功！<br/>';
				}else
				{
					$str.='删除知识点分类《'.$title.'》失败！<br/>';
				}            
			}  
		}
		echo $str;
	}	
	//更新或添加所有行
	public function actionAddandupdate(){
	//添加所有
	if(Yii::app()->request->getPost('action')=='addall')
	{
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
    //print_r($newarr);
    foreach($newarr as $value){
        $title=trim($value['title']);
		
        $criteria=new CDbCriteria(array(
			'condition'=>"title='$title'",
		));
		$count = Knowledgelist::model()->count($criteria);
        
        if($count>0){
            $str.='知识点分类《'.$title.'》已经存在，请更换！<br/>';
        }else{
				$model=new Knowledgelist;
				$Knowledgelist['title']=$title;
                $model->attributes=$Knowledgelist;
            if($model->save()){
                $str.='插入知识点分类《'.$title.'》成功！<br/>';
            }else
            {
                $str.='插入知识点分类《'.$title.'》失败！<br/>';
            }            
        }  
    }
	//更新所有
	}
	if(Yii::app()->request->getPost('action')=='updateall')
	{
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
    //print_r($newarr);
    foreach($newarr as $value){
        $title=trim($value['title']);
		$id=trim($value['id']);
        $criteria=new CDbCriteria(array(
			'condition'=>"title='$title' and id!='$id'",
		));
		$count = Knowledgelist::model()->count($criteria);
        
        if($count>0){
            $str.='知识点分类《'.$title.'》已经存在，请更换！<br/>';
        }else{
				$model=$this->loadModel($id);
				$Knowledgelist['title']=$title;
                $model->attributes=$Knowledgelist;
            if($model->save()){
                $str.='更新知识点分类《'.$title.'》成功！<br/>';
            }else
            {
                $str.='更新知识点分类《'.$title.'》失败！<br/>';
            }            
        }  
    }
	}
	echo $str;	
	}
}
