<?php

class KnowledgepointController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common2';
	public $assetsUrl;
	public function init()
	{
		//$this->assetsUrl=$this->module->assetsUrl;
		//不再注册核心脚本，因为要生成两次Yii jquery 文件。
		//Yii::app()->getClientScript()->registerCoreScript('jquery');
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate($category_id=0)
	{
		
				$model=new Knowledgepoint;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		

		
		
		
		if(isset($_POST['Knowledgepoint']))
		{
			$title=$_POST['Knowledgepoint']['title'];
			$criteria=new CDbCriteria(array(
				'condition'=>"title='$title'",
			));
			$count = $model->count($criteria);
        
			if($count>0){
				echo "no";exit;
			}			
			
			$model->attributes=$_POST['Knowledgepoint'];
			if($model->save())
				{echo "yes";exit;}
		}

		$this->render('create',array(
			'model'=>$model,'data'=>$category_id,
		));
		
		
		
		
		
		
		/*
		$model=new Knowledgepoint;
		if(isset($_POST['Knowledgepoint'])){
			$model->attributes=$_POST['Knowledgepoint'];
			if($model->save()){
				echo "yes";print_r($_POST['Knowledgepoint']);
			}else{echo "no";print_r($_POST['Knowledgepoint']);}
			//exit;		
		}else{
		$this->render('create',array('data'=>$category_id));
		}
		*/
				
	}
	public function actionC(){
		$this->render('create');
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);
		$title=$data['Knowledgepoint']['title']=trim(Yii::app()->request->getPost('title'));
		$data['Knowledgepoint']['content']=Yii::app()->request->getPost('content');
		$data['Knowledgepoint']['knowledgelist_id']=Yii::app()->request->getPost('knowledgelist_id');
		$id=Yii::app()->request->getPost('id');
		        
        $criteria=new CDbCriteria(array(
			'condition'=>"title='$title' and id!='$id'",
		));
		$count = $model->count($criteria);
        
        if($count>0){
            echo "no";exit;
        }
		
		
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);
		$model->attributes=$data['Knowledgepoint'];
		if($model->save()){
			echo "yes";
		}
		exit;
		if(isset($_POST['Knowledgepoint']))
		{
			$model->attributes=$_POST['Knowledgepoint'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		//$dataProvider=new CActiveDataProvider('Knowledgepoint');
		//$this->render('index',array(
			//'dataProvider'=>$dataProvider,
		//));
		$data=Knowledgelist::model()->findAll();
		$this->render('index',array(
			'data'=>$data,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Knowledgepoint('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Knowledgepoint']))
			$model->attributes=$_GET['Knowledgepoint'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Knowledgepoint::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='knowledgepoint-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	//取所有数据
	public function actionQq($category_id){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		$model=new Knowledgepoint;
		$criteria=new CDbCriteria(array(
			'order'=>"$sort $order",
			//'select'=>array('id','title'),//'id,title',
			'condition'=>"knowledgelist_id='$category_id'",
			'limit'=>$rows,
			'offset'=>($page-1)*$rows
		));

		$count = $model->count($criteria);
		/*第二种分页方案
		$pager = new CPagination($count);
		$pager->pageSize = $rows;
		$pager->applyLimit($criteria);
		$pager->currentPage=$page;
		$criteria->offset = ($page-1) * $rows;
		*/
		//echo $pager->currentPage;
		//echo $criteria->offset;
		$data=$model->findAll($criteria);
		$data2=CJSON::encode($data);
		$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
		echo $data;		
	}
	public function actionEditrow($id){
		$data=$this->loadModel($id);
		$data_list=Knowledgelist::model()->findAll();
		//echo CJSON::encode($data);
		$this->render('edit',array(
			'data'=>$data,
			'data_list'=>$data_list,
		));
	}
	public function actionList($category_id){
		$this->render('admin',array(
			'data'=>$category_id,
		));
	}
	//>---------------------单行删除
	public function actionDeleterow(){
		$id=Yii::app()->request->getPost('id');
		if($this->loadModel($id)->delete()){
			echo "yes";
		}
	}
	//>---------------多行删除
	public function actionDeleteall(){
		$arr=(array)(CJSON::decode(Yii::app()->request->getPost('qq')));
		foreach($arr as $value){
			$newarr[]=(array)$value;
		}
		$str='';
		//print_r($newarr);
		foreach($newarr as $value){
			$title=trim($value['title']);
			$id=trim($value['id']);
				if($this->loadModel($id)->delete()){
					$str.='删除知识点《'.$title.'》成功！<br/>';
				}else
				{
					$str.='删除知识点《'.$title.'》失败！<br/>';
				}            
		}
		echo $str;
	}
}
