<?php

class ScoreController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common2';
	public $assetsUrl;
	public function init()
	{
		//$this->assetsUrl=$this->module->assetsUrl;
		//不再注册核心脚本，因为要生成两次Yii jquery 文件。
		//Yii::app()->getClientScript()->registerCoreScript('jquery');
	}
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Score;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Score']))
		{
			$model->attributes=$_POST['Score'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Score']))
		{
			$model->attributes=$_POST['Score'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Score');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Score('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Score']))
			$model->attributes=$_GET['Score'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Score::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='score-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionList($classroom_id=null,$grade_id=null){
		$data=Exammanage::model()->findAll();
		if(isset($classroom_id)){
			$this->render('admin_classroom',array(
				'classroom_id'=>$classroom_id,
				'data'=>$data,
			));	
		}
		if(isset($grade_id)){
			$this->render('admin_grade',array(
				'grade_id'=>$grade_id,
				'data'=>$data,
			));	
		}
	}
	//取所有数据
	public function actionQq($classroom_id=null){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$exam_id=Yii::app()->request->getPost('exam_id');//查询标题
		//$condition_1="t.classroom_id='$classroom_id'";
		$condition="t.classroom_id='$classroom_id' and t.exam_id='$exam_id'";
		//$condition=(isset($exam_id))?$condition_2:$condition_1;
		
		$model=new Score;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'knowledgepoint.title,t.id,t.title',
			'condition'=>$condition,
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			'with'=>array('student_fullname'),
		));

		$count = $model->count($criteria);
		//exit;
		$data3=$model->findAll($criteria);
		$json = new CArJSON();
		// Define which relations do you want to load
		$relations = array('student_fullname');
		// Define which attributes, foreach relations do you want to load
		// root denote attributes for the main model
		$attributes = array(
			'root' => array('id','singlechoiceScore','multichoiceScore','judgeScore','operateScore','totalScore','reexam'),//表示主表中的字段
			'student_fullname' => array( 'fullname' ),//表示从表中的字段
			//'votes' => null, // This will load all attributes
		);
		$data=$json->toJSON($data3, $relations, $attributes);
		//print_r(CJSON::decode($data));
		$i=0;$newarr=array();
		foreach(CJSON::decode($data) as $key=>$value)
		{
			//echo $key;echo $value['attributes']['id'];
			$newarr[$i]['id']=$value['attributes']['id'];
			//$newarr[$i]['title']=$value['attributes']['title'];
			$newarr[$i]['singlechoiceScore']=$value['attributes']['singlechoiceScore'];
			$newarr[$i]['multichoiceScore']=$value['attributes']['multichoiceScore'];
			$newarr[$i]['judgeScore']=$value['attributes']['judgeScore'];
			$newarr[$i]['operateScore']=$value['attributes']['operateScore'];
			$newarr[$i]['totalScore']=$value['attributes']['totalScore'];
			$newarr[$i]['reexam']=($value['attributes']['reexam'])?'Yes':'No';
			$newarr[$i]['fullname']=$value['relations']['student_fullname']['fullname'];$i++;
		}

			$data2=CJSON::encode($newarr);
			$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
			echo $data;	
	}
	//取所有数据,年级模式
	public function actionQq2($grade_id=null){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$exam_id=Yii::app()->request->getPost('exam_id');//查询标题
		//$condition_1="t.grade_id='$grade_id'";
		$condition="t.grade_id='$grade_id' and t.exam_id='$exam_id'";
		//$condition=(isset($exam_id))?$condition_2:$condition_1;
		
		$model=new Score;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'knowledgepoint.title,t.id,t.title',
			'condition'=>$condition,
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			'with'=>array('student_fullname','classroom_title'),
		));

		$count = $model->count($criteria);
		//exit;
		$data3=$model->findAll($criteria);
		$json = new CArJSON();
		// Define which relations do you want to load
		$relations = array('student_fullname','classroom_title');
		// Define which attributes, foreach relations do you want to load
		// root denote attributes for the main model
		$attributes = array(
			'root' => array('id','singlechoiceScore','multichoiceScore','judgeScore','operateScore','totalScore','reexam'),//表示主表中的字段
			'student_fullname' => array( 'fullname' ),//表示从表中的字段
			'classroom_title' => array( 'title' ),//表示从表中的字段
			//'votes' => null, // This will load all attributes
		);
		$data=$json->toJSON($data3, $relations, $attributes);
		//print_r(CJSON::decode($data));
		$i=0;$newarr=array();
		foreach(CJSON::decode($data) as $key=>$value)
		{
			//echo $key;echo $value['attributes']['id'];
			$newarr[$i]['id']=$value['attributes']['id'];
			//$newarr[$i]['title']=$value['attributes']['title'];
			$newarr[$i]['singlechoiceScore']=$value['attributes']['singlechoiceScore'];
			$newarr[$i]['multichoiceScore']=$value['attributes']['multichoiceScore'];
			$newarr[$i]['judgeScore']=$value['attributes']['judgeScore'];
			$newarr[$i]['operateScore']=$value['attributes']['operateScore'];
			$newarr[$i]['totalScore']=$value['attributes']['totalScore'];
			$newarr[$i]['reexam']=($value['attributes']['reexam'])?'Yes':'No';
			$newarr[$i]['fullname']=$value['relations']['student_fullname']['fullname'];
			$newarr[$i]['classroom_id']=$value['relations']['classroom_title']['title'];
			$i++;
		}

			$data2=CJSON::encode($newarr);
			$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
			echo $data;	
	}
}
