<?php

class SystemsetupController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common';
	public $assetsUrl;
	public function init()
	{
		//$this->assetsUrl=$this->module->assetsUrl;
		//不再注册核心脚本，因为要生成两次Yii jquery 文件。
		//Yii::app()->getClientScript()->registerCoreScript('jquery');
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','update'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Systemsetup;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Systemsetup']))
		{
			$model->attributes=$_POST['Systemsetup'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Systemsetup']))
		{
			$model->attributes=$_POST['Systemsetup'];
			$model->logo=CUploadedFile::getInstance($model,'logo');
			//$file=CUploadedFile::getInstance($model,’filename’); 
			//获取表单名为filename的上传信息  
			if(isset($model->logo)){
				$filename=$model->logo->getName();          
				//获取文件名                                                                          
				//$filesize=$file->getSize();                 
				//获取文件大小                                                                     
				//$filetype=$file->getType();                
				//获取文件类型                                                                   
															  
				$filename1=iconv("utf-8", "gb2312", $model->logo);
				//这里是处理中文的问题，非中文不需要   
				$uploadfile=Yii::app()->basePath."/../myfiles/".$filename1;  
				$model->logo->saveAs($uploadfile,true);//上传操作
				$model->logo="/myfiles/".$filename;  			
			}else{
				unset($model->logo);
			}
               
			//数据库中要存放文件名 
			if($model->save()){
				//$model->logo->saveAs('/myfiles/');
				$this->redirect(array('index'));
				}
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$data=Systemsetup::model()->findBypk(1);
		$this->render('index',array(
			'data'=>$data,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Systemsetup('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Systemsetup']))
			$model->attributes=$_GET['Systemsetup'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Systemsetup::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='systemsetup-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionHelp()
	{
		$data=Systemsetup::model()->findBypk(1);
		$this->render('help',array(
			'data'=>$data,
		));
	}
	public function actionSysteminit()
	{
		$this->render('systeminit');
	}
	public function actionExeinit()
	{
		Yii::app()->db->createCommand()->truncateTable('yii_assign');
		Yii::app()->db->createCommand()->truncateTable('yii_assistant');
		Yii::app()->db->createCommand()->truncateTable('yii_category');
		Yii::app()->db->createCommand()->truncateTable('yii_classroom');
		Yii::app()->db->createCommand()->truncateTable('yii_errorset');
		Yii::app()->db->createCommand()->truncateTable('yii_exammanage');
		Yii::app()->db->createCommand()->truncateTable('yii_favorites');
		Yii::app()->db->createCommand()->truncateTable('yii_grade');
		Yii::app()->db->createCommand()->truncateTable('yii_invigilator');
		Yii::app()->db->createCommand()->truncateTable('yii_judge');
		Yii::app()->db->createCommand()->truncateTable('yii_knowledgelist');
		Yii::app()->db->createCommand()->truncateTable('yii_knowledgepoint');
		Yii::app()->db->createCommand()->truncateTable('yii_multichoice');
		Yii::app()->db->createCommand()->truncateTable('yii_myexam');
		Yii::app()->db->createCommand()->truncateTable('yii_operation');
		Yii::app()->db->createCommand()->truncateTable('yii_score');
		Yii::app()->db->createCommand()->truncateTable('yii_singlechoice');
		Yii::app()->db->createCommand()->truncateTable('yii_student');
		echo "<h1>初始化成功！</h1>";
		//$this->render('exeinit');
	}
}
