<?php

/**
 * This is the model class for table "{{assign}}".
 *
 * The followings are the available columns in table '{{assign}}':
 * @property integer $id
 * @property string $assistant_id
 * @property string $classroom_id
 * @property string $exam_id
 * @property string $score_list
 */
class Assign extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Assign the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{assign}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('assistant_id, score_list', 'required'),
			array('assistant_id, classroom_id, exam_id, score_list', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, assistant_id, classroom_id, exam_id, score_list', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'assign_fullname' => array(self::BELONGS_TO, 'Assistant', 'assistant_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'assistant_id' => '助手',
			'classroom_id' => 'Classroom',
			'exam_id' => 'Exam',
			'score_list' => '操作题列表',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('assistant_id',$this->assistant_id,true);
		$criteria->compare('classroom_id',$this->classroom_id,true);
		$criteria->compare('exam_id',$this->exam_id,true);
		$criteria->compare('score_list',$this->score_list,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function behaviors()
	{
		return array(
			'CArJSON'=>array(
				//'class'=>'ext.EJsonBehavior',
				//'class'=>'application.extensions.EJsonBehavior'
				'class'=>'ext.CArJSON',
		));
	}
}