<?php

/**
 * This is the model class for table "{{category}}".
 *
 * The followings are the available columns in table '{{category}}':
 * @property string $id
 * @property string $root
 * @property string $lft
 * @property string $rgt
 * @property integer $level
 * @property string $title
 */
class Category extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Category the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{category}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title', 'required'),
			//array('level', 'numerical', 'integerOnly'=>true),
			//array('root, lft, rgt', 'length', 'max'=>10),
			//array('title', 'length', 'max'=>128),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			//array('id, root, lft, rgt, level, title', 'safe', 'on'=>'search'),
		);
	}
	public function behaviors()
	{
		return array(
			'NestedSetBehavior'=>array(
				'class'=>'ext.NestedSetBehavior',
				'leftAttribute'=>'lft',
				'rightAttribute'=>'rgt',
				'levelAttribute'=>'level',
				'hasManyRoots'=>true,
		));
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'root' => 'Root',
			'lft' => 'Lft',
			'rgt' => 'Rgt',
			'level' => 'Level',
			'title' => 'Title',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('root',$this->root,true);
		$criteria->compare('lft',$this->lft,true);
		$criteria->compare('rgt',$this->rgt,true);
		$criteria->compare('level',$this->level);
		$criteria->compare('title',$this->title,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	//输出树
	public static  function printULTree($test_type){
		 $categories=Category::model()->findAll(array('order'=>'root,lft'));
		 $level=0;
		 $onoff=1;//使class=tree只出现在第一个UL中
	   foreach($categories as $n=>$category)
	   {

		   if($category->level==$level)
			   echo CHtml::closeTag('li')."\n";
		   else if($category->level>$level)
		   {
			   if($onoff==1)
				   echo CHtml::openTag('ul',array('id'=>'tt','class'=>'easyui-tree','data-options'=>"animate:true,lines:true"))."\n";
			   else
				   echo CHtml::openTag('ul')."\n";
		   }      
			   
		   else
		   {
			   echo CHtml::closeTag('li')."\n";

			   for($i=$level-$category->level;$i;$i--)
			   {
				   echo CHtml::closeTag('ul')."\n";
				   echo CHtml::closeTag('li')."\n";
			   }
		   }
			echo CHtml::openTag('li',array('data-options'=>"id:$category->id"));
			echo CHtml::openTag('span');
			 echo "<a href=\"javascript:addTab('$category->title','/admin/$test_type/list/charpter_id/$category->id')\">";
		   //echo CHtml::openTag('a',array('onclick'=>"addTab('s','s')"));
		   echo CHtml::encode($category->title);
			 echo "</a>";
			echo CHtml::closeTag('span');
		   $level=$category->level;$onoff=0;
	   }

	   for($i=$level;$i;$i--)
	   {
		   echo CHtml::closeTag('li')."\n";
		   echo CHtml::closeTag('ul')."\n";
	   }
		
	}
}