<?php

/**
 * This is the model class for table "{{classroom}}".
 *
 * The followings are the available columns in table '{{classroom}}':
 * @property integer $id
 * @property string $title
 * @property string $grade_id
 */
class Classroom extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Classroom the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{classroom}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, grade_id', 'required'),
			array('title, grade_id', 'length', 'max'=>8),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, title, grade_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'nianji' => array(self::BELONGS_TO, 'Grade', 'grade_id'),//班级属于年级
			//'student' => array(self::HAS_MANY, 'Student', 'classroom_id', 'condition'=>'classrooms.id=students.classroom_id','order'=>'classrooms.id DESC'),
			//'studentCount' => array(self::STAT, 'Student', 'classroom_id', 'condition'=>'classroom_id=classrooms.id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => 'Title',
			'grade_id' => 'Grade',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('grade_id',$this->grade_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	//不得不用扩展呀
	public function behaviors()
	{
		return array(
			'CArJSON'=>array(
				//'class'=>'ext.EJsonBehavior',
				//'class'=>'application.extensions.EJsonBehavior'
				'class'=>'ext.CArJSON',
		));
	}
}