<?php

/**
 * This is the model class for table "{{exammanage}}".
 *
 * The followings are the available columns in table '{{exammanage}}':
 * @property integer $id
 * @property string $title
 * @property string $singlechoicelist
 * @property string $multichoicelist
 * @property string $judgelist
 * @property string $fillinlist
 * @property string $faqlist
 * @property string $operatelist
 * @property string $testScore
 * @property string $testCount
 * @property string $testRand
 * @property string $summary
 * @property integer $examState
 * @property integer $examMode
 * @property integer $examTime
 * @property integer $beforeSubmit
 * @property string $created
 * @property string $modified
 */
class Exammanage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Exammanage the static model class
	 */
	public $singlechoicelist_range;
	public $multichoicelist_range;
	public $judgelist_range;
	public $operatelist_range;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{exammanage}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, testScore, testCount, testRand, summary, examState, examMode, examTime, beforeSubmit,testtype', 'required'),
			array('examState, examMode, examTime, beforeSubmit, testtype', 'numerical', 'integerOnly'=>true),
			array('title', 'length', 'max'=>256),
			array('testScore, testCount, testRand', 'length', 'max'=>32),
			array('title, singlechoicelist, multichoicelist, judgelist, fillinlist, faqlist, operatelist, testScore, testCount, testRand, summary, examState, examMode, created, modified', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, title, singlechoicelist, multichoicelist, judgelist, fillinlist, faqlist, operatelist, testScore, testCount, testRand, summary, examState, examMode, examTime, beforeSubmit, created, modified', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			//'score_exam' => array(self::HAS_MANY, 'Score', 'id','condition'=>'charpter_id=category.id'),//一道试题属于一个目录
			'score_exam' => array(self::HAS_MANY, 'Score', 'id'),//,'condition'=>'t.id=score_exam.exam_id'
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => '标题',
			'singlechoicelist' => '单选列表',
			'singlechoicelist_range' => '单选列表范围',
			'multichoicelist' => '多选列表',
			'multichoicelist_range' => '多选列表范围',
			'judgelist' => '判断列表',
			'judgelist_range' => '判断列表范围',
			'fillinlist' => '填空列表',
			'faqlist' => '问题列表',
			'operatelist' => '操作列表',
			'operatelist_range' => '操作列表范围',
			'testScore' => '各题型分值',
			'testCount' => '各题型数量',
			'testRand' => '各题型随机',
			'summary' => '考试简介',
			'examState' => '是否禁用',
			'examMode' => '是否考试',
			'examTime' => '考试时间',
			'beforeSubmit' => '提前交卷',
			'created' => '创建时间',
			'modified' => '修改时间',
			'testtype' => '试题类型',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('singlechoicelist',$this->singlechoicelist,true);
		$criteria->compare('multichoicelist',$this->multichoicelist,true);
		$criteria->compare('judgelist',$this->judgelist,true);
		$criteria->compare('fillinlist',$this->fillinlist,true);
		$criteria->compare('faqlist',$this->faqlist,true);
		$criteria->compare('operatelist',$this->operatelist,true);
		$criteria->compare('testScore',$this->testScore,true);
		$criteria->compare('testCount',$this->testCount,true);
		$criteria->compare('testRand',$this->testRand,true);
		$criteria->compare('summary',$this->summary,true);
		$criteria->compare('examState',$this->examState);
		$criteria->compare('examMode',$this->examMode);
		$criteria->compare('examTime',$this->examTime);
		$criteria->compare('beforeSubmit',$this->beforeSubmit);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('testtype',$this->testtype,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function behaviors()
	{
		return array(
			'CArJSON'=>array(
				//'class'=>'ext.EJsonBehavior',
				//'class'=>'application.extensions.EJsonBehavior'
				'class'=>'ext.CArJSON',
		));
	}
	protected function beforeSave()
	{
		if(parent::beforeSave())
		{
			if($this->isNewRecord)
			{
				$this->created=$this->modified=date("Y-m-d H:i:s",time()+8*3600);
			}
			else
				$this->modified=date("Y-m-d H:i:s",time()+8*3600);
			return true;
		}
		else
			return false;
	}
	/*
	protected function afterSave(){
		if(parent::afterSave())
		{
			$data=Tempdata::model()->findByPk(1);
			//$data->attributes=array('operate_id'=>'','judge_id'=>'','multi_id'=>'','single_id'=>'');
					$data=Tempdata::model()->findByPk(1);
		$data->single_id='';
		$data->multi_id='';
		$data->judge_id='';
		$data->operate_id='';
			if($data->update()){
				return true;
			}
		}else
			return false;
	}
	*/
}