<?php

/**
 * This is the model class for table "{{knowledgepoint}}".
 *
 * The followings are the available columns in table '{{knowledgepoint}}':
 * @property integer $id
 * @property string $title
 * @property string $content
 * @property string $created
 * @property string $modified
 * @property integer $knowledgelist_id
 */
class Knowledgepoint extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Knowledgepoint the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{knowledgepoint}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, content, knowledgelist_id', 'required'),
			//array('knowledgelist_id', 'numerical', 'integerOnly'=>true),
			//array('title', 'length', 'max'=>256),
			//array('modified', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			//array('id, title, content, created, modified, knowledgelist_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => '标题',
			'content' => '内容',
			'created' => 'Created',
			'modified' => 'Modified',
			'knowledgelist_id' => 'Knowledgelist',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('content',$this->content,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('knowledgelist_id',$this->knowledgelist_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	protected function beforeSave()
	{
		if(parent::beforeSave())
		{
			if($this->isNewRecord)
			{
				$this->created=$this->modified=date("Y-m-d H:i:s",time()+8*3600);
			}
			else
				$this->modified=date("Y-m-d H:i:s",time()+8*3600);
			return true;
		}
		else
			return false;
	}
}