<?php

/**
 * This is the model class for table "{{singlechoice}}".
 *
 * The followings are the available columns in table '{{singlechoice}}':
 * @property integer $id
 * @property string $title
 * @property string $tigan
 * @property string $tizhi 
 * @property string $answer
 * @property integer $knowledgepoint_id
 * @property integer $charpter_id
 * @property string $created
 * @property string $modified
 * @property integer $frequency
 * @property integer $difficulty
 * @property integer $forbidden
 */
class Singlechoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Singlechoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{singlechoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, tigan,tizhi, answer, knowledgepoint_id, charpter_id, created, modified, frequency, difficulty, forbidden', 'required'),
			array('knowledgepoint_id, charpter_id, frequency, difficulty, forbidden', 'numerical', 'integerOnly'=>true),
			array('answer', 'length', 'max'=>64),
			array('created, modified', 'length', 'max'=>32),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, title, tigan,tizhi, answer, knowledgepoint_id, charpter_id, created, modified, frequency, difficulty, forbidden', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'singletest' => array(self::BELONGS_TO, 'Knowledgepoint', 'knowledgepoint_id'),//一道试题属于一个知识点
			'singlecharpter' => array(self::BELONGS_TO, 'Category', 'charpter_id'),//一道试题属于一个目录
			//'singlecharpter' => array(self::BELONGS_TO, 'Category', 'charpter_id','condition'=>'charpter_id=category.id'),//一道试题属于一个目录
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => '标题',
			'tigan' => '题干',
			'tizhi' => '题支',
			'answer' => '答案',
			'knowledgepoint_id' => '知识点',
			'charpter_id' => '章节',
			'created' => '创建时间',
			'modified' => '修改时间',
			'frequency' => '频率',
			'difficulty' => '难度',
			'forbidden' => '禁用',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('tigan',$this->title,true);
		$criteria->compare('tizhi',$this->content,true);
		$criteria->compare('answer',$this->answer,true);
		$criteria->compare('knowledgepoint_id',$this->knowledgepoint_id);
		$criteria->compare('charpter_id',$this->charpter_id);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('frequency',$this->frequency);
		$criteria->compare('difficulty',$this->difficulty);
		$criteria->compare('forbidden',$this->forbidden);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	//不得不用扩展呀
	public function behaviors()
	{
		return array(
			'CArJSON'=>array(
				//'class'=>'ext.EJsonBehavior',
				//'class'=>'application.extensions.EJsonBehavior'
				'class'=>'ext.CArJSON',
		));
	}
	protected function beforeSave()
	{
		if(parent::beforeSave())
		{
			if($this->isNewRecord)
			{
				$this->created=$this->modified=date("Y-m-d H:i:s",time()+8*3600);
			}
			else
				$this->modified=date("Y-m-d H:i:s",time()+8*3600);
			return true;
		}
		else
			return false;
	}
}