<?php

/**
 * This is the model class for table "{{singlechoice}}".
 *
 * The followings are the available columns in table '{{singlechoice}}':
 * @property integer $id
 * @property string $title
 * @property string $content
 * @property string $prompt
 * @property string $answer
 * @property string $charpter_id
 * @property string $created
 * @property string $modified
 * @property integer $difficulty
 * @property integer $forbidden
 */
class Singlechoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Singlechoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{singlechoice}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('title, content, prompt, answer, charpter_id, created, modified, difficulty, forbidden', 'required'),
			array('difficulty, forbidden', 'numerical', 'integerOnly'=>true),
			array('answer', 'length', 'max'=>64),
			array('charpter_id', 'length', 'max'=>8),
			array('created, modified', 'length', 'max'=>32),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, title, content, prompt, answer, charpter_id, created, modified, difficulty, forbidden', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'title' => '标题',
			'content' => '内容',
			'prompt' => '提示',
			'answer' => '答案',
			'charpter_id' => '章节',
			'created' => '创建日期',
			'modified' => '修改日期',
			'difficulty' => '难度',
			'forbidden' => '禁用',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('content',$this->content,true);
		$criteria->compare('prompt',$this->prompt,true);
		$criteria->compare('answer',$this->answer,true);
		$criteria->compare('charpter_id',$this->charpter_id,true);
		$criteria->compare('created',$this->created,true);
		$criteria->compare('modified',$this->modified,true);
		$criteria->compare('difficulty',$this->difficulty);
		$criteria->compare('forbidden',$this->forbidden);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}