<?php

/**
 * ContactForm 类.
 * ContactForm 是会一直使用的数据结构
 * contact表单. 它被用作'SiteController'控制器的'contact'动作。
 */
class StudentForm extends CFormModel
{
	public $username;
	public $fullname;
	public $sex;
	public $classroom_id;
	public $grade_id;
	public $remark;
	public $photo;
	/**
	 * 声明验证规则.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fullname, sex, classroom_id, grade_id', 'required'),
			array('sex', 'numerical', 'integerOnly'=>true),
			//array('photo','file','types'=>'jpg,gif,png','maxSize'=>'524288','allowEmpty'=>true),
			array('photo','file','types'=>'jpg,gif,png','maxSize'=>'524288','allowEmpty'=>true),//原版
			array('remark', 'safe'),
			array('fullname', 'match','pattern'=>"/^[\x7f-\xff]+$/",'message'=>"姓名只能是中文！"),//这行也能用。还有说是080
			array('username', 'match','pattern'=>"/^[".chr(0xa1)."-".chr(0xff)."A-Za-z0-9_]+$/",'message'=>"只允许字母、数字、下划线！"),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, username, fullname, sex, classroom_id, grade_id', 'safe', 'on'=>'search'),
			//array('password,confirmPassword','alter_pwd','on'=>'update'),
		);
	}

	/**
	 * 声明自定义的属性标签
	 * 如果这里没有定义, 一个属性标签将和它的名字一样，只是第一个字母大写。
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'username' => '用户名',
			'password' => '密码',
			'salt' => 'Salt',
			'fullname' => '姓名',
			'sex' => '性别',
			'classroom_id' => '班级',
			'grade_id' => '年级',
			'photo' => '照片',
			'remark' => '自我介绍',
			'verifyCode'=>'验证码',
			'confirmPassword'=>'确认密码',
			'rememberMe'=>'记住我',
			'created'=>'创建日期',
			'modified'=>'修改日期',
		);
	}
}