<?php

/**
 * This is the model class for table "{{systemsetup}}".
 *
 * The followings are the available columns in table '{{systemsetup}}':
 * @property integer $id
 * @property string $systemName
 * @property string $copyright
 * @property string $logo
 * @property string $notice
 * @property string $keywords
 * @property string $description
 * @property integer $register
 * @property integer $exammode
 * @property string $help
 */
class Systemsetup extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Systemsetup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{systemsetup}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('systemName, copyright, notice, keywords, description, register, exammode, help', 'required'),
			array('register, exammode', 'numerical', 'integerOnly'=>true),
			array('systemName', 'length', 'max'=>64),
			array('copyright, keywords', 'length', 'max'=>256),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, systemName, copyright, logo, notice, keywords, description, register, exammode, help', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'systemName' => '系统名称',
			'copyright' => '版权所有',
			'logo' => '系统标志',
			'notice' => '通知公告',
			'keywords' => '关键词',
			'description' => '描述',
			'register' => '关闭注册',
			'exammode' => '正常模式',
			'help' => '系统帮助',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('systemName',$this->systemName,true);
		$criteria->compare('copyright',$this->copyright,true);
		$criteria->compare('logo',$this->logo,true);
		$criteria->compare('notice',$this->notice,true);
		$criteria->compare('keywords',$this->keywords,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('register',$this->register);
		$criteria->compare('exammode',$this->exammode);
		$criteria->compare('help',$this->help,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}