<?php

/**
 * This is the model class for table "{{tempdata}}".
 *
 * The followings are the available columns in table '{{tempdata}}':
 * @property integer $id
 * @property string $single_id
 * @property string $multi_id
 * @property string $judge_id
 * @property string $faq_id
 * @property string $fillin_id
 * @property string $operate_id
 */
class Tempdata extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Tempdata the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{tempdata}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('single_id, multi_id, judge_id, faq_id, fillin_id, operate_id', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, single_id, multi_id, judge_id, faq_id, fillin_id, operate_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'single_id' => 'Single',
			'multi_id' => 'Multi',
			'judge_id' => 'Judge',
			'faq_id' => 'Faq',
			'fillin_id' => 'Fillin',
			'operate_id' => 'Operate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('single_id',$this->single_id,true);
		$criteria->compare('multi_id',$this->multi_id,true);
		$criteria->compare('judge_id',$this->judge_id,true);
		$criteria->compare('faq_id',$this->faq_id,true);
		$criteria->compare('fillin_id',$this->fillin_id,true);
		$criteria->compare('operate_id',$this->operate_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}