<?php
/* @var $this AssignController */
/* @var $model Assign */
/* @var $form CActiveForm */
?>

<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'assign-form',
	'enableAjaxValidation'=>false,
)); ?>

	<p class="note">带<span class="required">*</span>号的为必填字段.</p>

	<?php echo $form->errorSummary($model); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'assistant_id'); ?>
		<?php echo $form->dropDownList($model,'assistant_id',CHtml::listData($assistant,'id','fullname'),array('prompt'=>'-请选择-')); ?>
		<?php echo $form->error($model,'assistant_id'); ?>
	</div>

	<div class="easyui-layout" style="width:100%;height:367px;">
		<div data-options="region:'center'" style="background:#fafafa;">
			<table id="tt">  
			</table>
		</div>
	</div>
	<?php 
		echo $form->hiddenField($model,'classroom_id');
		echo $form->hiddenField($model,'exam_id');
	?>
	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? '新建' : '保存'); ?>
	</div>

<?php $this->endWidget(); ?>

</div><!-- form -->
<script type="text/javascript">
	$(function(){

		$('#tt').datagrid({  
			title:'操作题列表',
			striped:true,
			pagination:true,
			queryParams:{classroom_id:<?php echo $model->classroom_id;?>,exam_id:<?php echo $model->exam_id;?>},
			remoteSort:true,
			sortName: 'id',
			sortOrder: 'asc',
			url:"<?php echo $this->createUrl('qq3'); ?>",  
			//idField:"id",
			//checkbox:false,
			fitColumns:true,
			toolbar:[{
					id:'btnRemove',
					iconCls: 'icon-add',
					text:'选择',
					disabled:true,
					handler: function(){
						var rows = $('#tt').datagrid('getSelections');
						var uprow = [];
							for(var i=0;i<rows.length;i++){
								uprow.push(rows[i]['id']);
							}
						//alert(JSON.stringify(uprow));
						
								$.messager.confirm('确认','确定要选择吗？',function(r){
								if (r){


										$.ajax({
											  type: 'POST',
											  url: '<?php echo $this->createUrl('selectall')?>',
											  data: {qq:JSON.stringify(uprow)},
											  success: function(data){//alert(data);
												   //if(data=="yes"){
													$.messager.alert('系统提示',data,'info');
													$('#tt').datagrid('reload');
													$('#btnRemove').linkbutton('disable');
													//$('#btnSave').linkbutton('disable');
												   //}else $.messager.alert('系统提示','更新失败!','info');
											   
											   },
											  dataType: "text"
										});	

								
								}
							});
	
					}},'-',{
                    id:'btnAllon',
					iconCls: 'icon-remove',
					text:'重新选择',
					handler: function(){
					
						var rows = $('#tt').datagrid('getSelections');
						var uprow = [];
							for(var i=0;i<rows.length;i++){
								uprow.push(rows[i]);
							}
						//alert(JSON.stringify(uprow));
						
								$.messager.confirm('确认','确定要重新选择吗？',function(r){
								if (r){


										$.ajax({
											  type: 'POST',
											  url: '<?php echo $this->createUrl('resetall')?>',
											  data: {action:''},
											  success: function(data){//alert(data);
												   //if(data=="yes"){
													$.messager.alert('系统提示',data,'info');
													$('#tt').datagrid('reload');
													$('#btnRemove').linkbutton('disable');
													//$('#btnSave').linkbutton('disable');
												   //}else $.messager.alert('系统提示','更新失败!','info');
											   
											   },
											  dataType: "text"
										});	

								
								}
							});
					
						}
					},					
					],
			
			columns:[[  
				{field:'ck',checkbox:'true'}, 
				{field:'id',title:'ID',width:50,align:'center',sortable:true},  
				{field:'fullname',title:'姓名',width:50,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}},
				{field:'operateScore',title:'操作题得分',width:200,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				//{field:'difficulty',title:'难度',width:50,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				//{field:'frequency',title:'频率',width:50,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				//{field:'forbidden',title:'禁用',width:50,align:'center',sortable:true,editor:{type:'checkbox',options:{"0":'P',"1":'Q'}}}, //这里的editor没用。可以取消
				//{field:'created',title:'创建日期',width:150,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				//{field:'modified',title:'修改日期',width:150,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 

			]],
            onSelect:function(index,row){
                $('#btnRemove').linkbutton('enable');
                },
			onUnselect:function(rowIndex, rowData){
				var rows = $('#tt').datagrid('getSelections');
				if(rows.length==0) {
					$('#btnRemove').linkbutton('disable');
				}
				},
            onSelectAll:function(index,row){
                $('#btnRemove').linkbutton('enable');
                },
            onUnselectAll:function(index,row){
                $('#btnRemove').linkbutton('disable');
                } 			
		}); 
	});
</script>