<script type="text/javascript">
	$(function(){
		$('#tt').datagrid({  
			title:'该班级下的助手列表',
			striped:true,
			pagination:true,
			//queryParams:{pageSize:'10',page:'10'},
			remoteSort:true,
			sortName: 'id',
			sortOrder: 'asc',
			url:"<?php echo $this->createUrl('qq',array('classroom_id'=>$classroom_id)); ?>",  
			//idField:"id",
			//checkbox:false,
			fitColumns:true,
			toolbar:"#tb",			
			columns:[[  
				{field:'ck',checkbox:'true'}, 
				{field:'id',title:'ID',width:50,align:'center',sortable:true},  
				{field:'fullname',title:'姓名',width:100,align:'center',sortable:false,editor:{type:'validatebox',options:{required:true}}}, 
				{field:'username',title:'账号',width:100,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				{field:'password',title:'密码',width:150,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				{field:'action',title:'动作',width:130,align:'center',
						formatter:function(value,row,index){
							if (row.editing){
								var s = '<a href="#" onclick="saverow('+index+')">保存</a> ';
								var c = '<a href="#" onclick="cancelrow('+index+')">取消</a>';
								return s+c;
							} else {
								var e = '<a href="#" onclick="editrow('+row.id+','+index+')">编辑</a> ';
								var d = '<a href="#" onclick="deleterow('+row.id+','+index+')">删除</a>';
								return e+d;
							}
						}
				}
			]],
			onBeforeEdit:function(index,row){
				row.editing = true;
				updateActions();
			},
			onAfterEdit:function(index,row){
				row.editing = false;
				var updateRows = $('#tt').datagrid('getChanges','updated');
				var insertRows = $('#tt').datagrid('getChanges','inserted');
				if(updateRows.length>0 || insertRows.length>0){
					$('#btnUndo').linkbutton('enable');
					$('#btnSave').linkbutton('enable');
				}
				updateActions();
			},
			onCancelEdit:function(index,row){
				row.editing = false;
				updateActions();
			},
            onSelect:function(index,row){
                $('#btnRemove').linkbutton('enable');
                },
			onUnselect:function(rowIndex, rowData){
				var rows = $('#tt').datagrid('getSelections');
				if(rows.length==0) $('#btnRemove').linkbutton('disable');
				},
            onSelectAll:function(index,row){
                $('#btnRemove').linkbutton('enable');
                },
            onUnselectAll:function(index,row){
                $('#btnRemove').linkbutton('disable');
                } 			
		}); 
	});
	function updateActions(){
		var rowcount = $('#tt').datagrid('getRows').length;
		for(var i=0; i<rowcount; i++){
			$('#tt').datagrid('updateRow',{
				index:i,
				row:{action:''}
			});
		}
	}
	function editrow(value,index){
		$('#tt').datagrid('beginEdit', index);
	}
	function deleterow(value,index){
		$.messager.confirm('确认','确定要删除吗？',function(r){
			if (r){
				if(typeof(value)=='undefined'){
					$('#tt').datagrid('deleteRow',index);
				}else{
					$.ajax({
						type: 'POST',
						url: '<?php echo $this->createUrl("deleterow")?>',
						data: {id:value},
						success: function(data){if(data=="yes"){
						$.messager.alert('系统提示','删除成功!','info');
						$('#tt').datagrid('deleteRow',index);
						$('#tt').datagrid('reload');
						//updateActions();
						$("#tt").datagrid("acceptChanges");
					   }else $.messager.alert('系统提示','删除失败!'+'<br />'+data,'info');},
					  dataType: "text"
					});	
				}
			
			}
		});
	}

	
	function saverow(index){
		$('#tt').datagrid('endEdit', index);
	}
	function cancelrow(index){
		$('#tt').datagrid('cancelEdit', index);
	}

function my_query(){
	if($.trim($("#title").val())==""){
		$.messager.alert('系统提示','请输入姓名!','info');
		$("#title").focus();
		return ;
	}
	var fullname=$.trim($("#title").val());
	var queryParams = $('#tt').datagrid('options').queryParams; 
	queryParams.fullname = fullname;  
	$('#tt').datagrid('options').queryParams=queryParams;        
	$("#tt").datagrid('reload'); 
}	
function display_all(){
	$('#tt').datagrid('options').queryParams=[];  
	$("#tt").datagrid('reload'); 
}



	function tt_add(){			
		var lastIndex = $('#tt').datagrid('getRows').length-1;
		$('#tt').datagrid('endEdit', lastIndex);
		$('#tt').datagrid('appendRow',{
			//id:'',
			//title:''
		});
		var lastIndex = $('#tt').datagrid('getRows').length-1;
		$('#tt').datagrid('beginEdit', lastIndex);			
	}
	function tt_save(){
					
		//$('#btnsave').linkbutton('enable');
		var updateRows = $('#tt').datagrid('getChanges','updated');
		var insertRows = $('#tt').datagrid('getChanges','inserted');
		if(updateRows.length==0 && insertRows.length==0){
			$.messager.alert('系统提示','请先编辑字段或添加行！','warning');
			return false;
		}//这是更新
		if(updateRows.length!=0){
			var uprow = [];var newdata=[];
			/*for(var i=0;i<updateRows.length;i++){
				uprow.push(updateRows[i].department_name);//alert($('#tt').datagrid('getRowIndex',rows[i]));
			}*/
			for(var i=0;i<updateRows.length;i++){
				uprow.push(updateRows[i]);//alert($('#tt').datagrid('getRowIndex',rows[i]));
			}
			
			$.ajax({
				  type: 'POST',
				  url: '<?php echo $this->createUrl('addandupdate')?>',
				  data: {action:'updateall',qq:JSON.stringify(uprow),classroom_id:<?php echo $classroom_id;?>},
				  success: function(data){//alert(data);
					   //if(data=="yes"){
						$.messager.alert('系统提示',data,'info');
						$('#btnUndo').linkbutton('disable');
						$('#btnSave').linkbutton('disable');
						$('#tt').datagrid('reload');
					   //}else $.messager.alert('系统提示','更新失败!','info');
				   
				   },
				  dataType: "text"
				});							
		}//这是添加
		if(insertRows.length!=0){
			var isrow = [];var newdata=[];
			for(var i=0;i<insertRows.length;i++){
				isrow.push(insertRows[i]);//alert($('#tt').datagrid('getRowIndex',rows[i]));
			}
			
			$.ajax({
				  type: 'POST',
				  url: '<?php echo $this->createUrl('addandupdate')?>',
				  data: {action:'addall',qq:JSON.stringify(isrow),classroom_id:<?php echo $classroom_id;?>},
				  success: function(data){//alert(data);
					   //if(data=="yes"){
						$.messager.alert('系统提示',data,'info');
						$('#tt').datagrid('reload');
						$('#btnUndo').linkbutton('disable');
						$('#btnSave').linkbutton('disable');
					   //}else $.messager.alert('系统提示','更新失败!','info');
				   
				   },
				  dataType: "text"
				});							
		}			
		$("#tt").datagrid("acceptChanges");
		//alert(JSON.stringify(isrow));

	}
	function tt_remove(){
		var rows = $('#tt').datagrid('getSelections');
		var uprow = [];
			for(var i=0;i<rows.length;i++){
				uprow.push(rows[i]);
			}
		//alert(JSON.stringify(uprow));
		$.ajax({
			  type: 'POST',
			  url: '<?php echo $this->createUrl('deleteall')?>',
			  data: {action:'deleteall',qq:JSON.stringify(uprow)},
			  success: function(data){//alert(data);
				   //if(data=="yes"){
					$.messager.alert('系统提示',data,'info');
					$('#tt').datagrid('reload');
					$('#btnRemove').linkbutton('disable');
					//$('#btnSave').linkbutton('disable');
				   //}else $.messager.alert('系统提示','更新失败!','info');
			   
			   },
			  dataType: "text"
		});	
	}
	function tt_undo(){
		$("#tt").datagrid("rejectChanges");$('#btnUndo,#btnSave').linkbutton('disable');
	}
</script>
<div data-options="region:'center',border:false">
	<table id="tt">  
	</table>
</div>
<div id="tb" style="padding:5px;height:auto">
	<div style="margin-bottom:5px">
		<a href="javascript:tt_add()" id="btnAdd" data-options="iconCls:'icon-add',plain:true,disabled:false" class="easyui-linkbutton" >增加</a>
		<a href="javascript:tt_save()" id="btnSave" data-options="iconCls:'icon-save',plain:true,disabled:false" disabled="true" class="easyui-linkbutton">保存</a>
		<a href="javascript:tt_remove()" id="btnRemove" data-options="iconCls:'icon-remove',plain:true,disabled:false" disabled="false" class="easyui-linkbutton">删除</a>
		<a href="javascript:tt_undo()" id="btnUndo" data-options="iconCls:'icon-undo',plain:true,disabled:false" disabled="false" class="easyui-linkbutton">撤销</a>
	</div>
	<div>
		姓名: <input id="title" type="text" style="width:300px"/>
		<a href="javascript:my_query()" class="easyui-linkbutton" iconCls="icon-search">搜索</a>
		<a href="javascript:display_all()" class="easyui-linkbutton" iconCls="icon-search">显示全部</a>
	</div>
</div>
