<?php

class AssistantController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='common2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Assistant;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Assistant']))
		{
			$model->attributes=$_POST['Assistant'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Assistant']))
		{
			$model->attributes=$_POST['Assistant'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Assistant');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Assistant('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Assistant']))
			$model->attributes=$_GET['Assistant'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Assistant the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Assistant::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Assistant $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='assistant-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionList($exam_id){
		$this->render('admin',array(
			'exam_id'=>$exam_id,
		));
	}
	public function actionQq($exam_id=null){
		$order=Yii::app()->request->getPost('order');
		$sort=Yii::app()->request->getPost('sort');
		$page=Yii::app()->request->getPost('page');
		$rows=Yii::app()->request->getPost('rows');
		
		$assistant_id=Yii::app()->assistant->id;
		$data=Assign::model()->find("assistant_id='$assistant_id' and exam_id='$exam_id'");
		if(isset($data))
			$arr_in=explode(",",$data->score_list);
		else
			$arr_in=array();
		$model=new Score;
		$criteria=new CDbCriteria(array(
			'order'=>"t.$sort $order",
			//'select'=>array('id','title'),//'id,title',
			//'select'=>'knowledgepoint.title,t.id,t.title',
			//'condition'=>$condition,
			'limit'=>$rows,
			'offset'=>($page-1)*$rows,
			'with'=>array('student_fullname'),
		));
		$criteria->addInCondition('t.id',$arr_in);
		$count = $model->count($criteria);
		//exit;
		$data3=$model->findAll($criteria);
		$json = new CArJSON();
		// Define which relations do you want to load
		$relations = array('student_fullname');
		// Define which attributes, foreach relations do you want to load
		// root denote attributes for the main model
		$attributes = array(
			'root' => array('id','score_list','operateScore'),//表示主表中的字段
			'student_fullname' => array( 'fullname' ),//表示从表中的字段
			//'votes' => null, // This will load all attributes
		);
		$data=$json->toJSON($data3, $relations, $attributes);
		//print_r(CJSON::decode($data));
		$newarr=array();
		foreach(CJSON::decode($data) as $key=>$value)
		{
			$newarr[]=array(
				'id'=>$value['attributes']['id'],
				'score_id'=>$value['attributes']['id'],
				'score_state'=>isset($value['attributes']['operateScore'])?'已评':'未评',
				'fullname'=>$value['relations']['student_fullname']['fullname'],
			);
		}

			$data2=CJSON::encode($newarr);
			$data='{'.'"total":'.$count.','.'"rows":'.$data2.'}';
			echo $data;	
	}
	public function actionPingjuan($id,$exam_id)
	{
		$model=Score::model()->find("id='$id'");
		if(isset($_POST['Score']))
		{	$_POST['Score']['totalScore']=$model->singlechoiceScore + $model->multichoiceScore + $model->judgeScore + $_POST['Score']['operateScore'];
			$model->attributes=$_POST['Score'];
			if($model->save())
			{
				header('Content-Type: text/html; charset=utf-8');
				echo "<script>alert('评卷成功！请关闭此窗口！');window.location.reload();</script>";
				Yii::app()->end();
			}
		}
		$student_id=$model->student_id;
		$data=Myexam::model()->find("student_id='$student_id' and exam_id='$exam_id'");
		$arr_order=explode(',',$data->operatelist);
		$criteria=new CDbCriteria(array(
			'select'=>array('id','tigan','tizhi','answer'),//'id,title',
			//'select'=>'knowledgepoint.title,t.id,t.title',
			//'condition'=>,
		));
		$criteria->addInCondition('id',$arr_order);
		$data2=Operation::model()->findAll($criteria);
		$arr=explode(",",$model->operateAnswer);//这行是学生答案
		$arr3=array();
		foreach($arr_order as $k=>$v)
		{
			foreach($data2 as $k2=>$v2)
			{
				if($v==$v2['id'])
				$arr3[]=array(
					'tigan'=>$v2['tigan'],
					'tizhi'=>$v2['tizhi'],
					'student_answer'=> current($arr),
					'answer'=>$v2['answer'],
				);
			}
			next($arr);
		}
		$this->render('pingjuan',array(
			'model'=>$model,
			'data'=>$arr3,			
		));		
	}
}
