<?php
/* @var $this ExammanageController */
/* @var $model Exammanage */

$this->breadcrumbs=array(
	'Exammanages'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List Exammanage', 'url'=>array('index')),
	array('label'=>'Create Exammanage', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('exammanage-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Exammanages</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'exammanage-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'id',
		'title',
		'singlechoicelist',
		'multichoicelist',
		'judgelist',
		'fillinlist',
		/*
		'faqlist',
		'operatelist',
		'testScore',
		'testCount',
		'testRand',
		'summary',
		'examState',
		'examMode',
		'examTime',
		'beforeSubmit',
		'created',
		'modified',
		*/
		array(
			'class'=>'CButtonColumn',
		),
	),
)); ?>
